﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Reflection;

namespace Kasuga
{
    public class KsgSubtitleElementConverter : TypeConverter
    {
        public override PropertyDescriptorCollection GetProperties(ITypeDescriptorContext context, object value, Attribute[] attributes)
        {
            try
            {
                if (value == null)
                {
                    return base.GetProperties(context, value, attributes);
                }
                else
                {
                    List<PropertyDescriptor> properties = new List<PropertyDescriptor>();
                    ISubtitleElement element = (ISubtitleElement)value;
                    PropertyDescriptorCollection elementDescriptors =
                        TypeDescriptor.GetProperties(element, attributes);
                    foreach (PropertyDescriptor elementDescriptor in elementDescriptors)
                    {
                        if (elementDescriptor.Name == "FormatDictionary")
                        {
                            Type formatType = null;
                            {
                                Type interfaceType = element.GetType().GetInterface("IHasFormatDictionary");
                                if (interfaceType != null)
                                {
                                    PropertyDescriptorCollection interfaceDescriptors =
                                        TypeDescriptor.GetProperties(interfaceType, attributes);
                                    PropertyDescriptor interfaceDescriptor = interfaceDescriptors.Find("FormatType", true);
                                    formatType = (Type)interfaceDescriptor.GetValue(element);
                                }
                            }
                            if (formatType != null)
                            {
                                PropertyDescriptorCollection formatDescriptors =
                                    TypeDescriptor.GetProperties(formatType, attributes);
                                foreach (PropertyDescriptor formatDescriptor in formatDescriptors)
                                {
                                    properties.Add(new FormatPropertyDescriptor(formatDescriptor));
                                }
                            }
                        }
                        else if (elementDescriptor.Name == "WordArrangementDictionary")
                        {
                            Type WordArrangementType = null;
                            {
                                Type interfaceType = element.GetType().GetInterface("IHasWordArrangementDictionary");
                                if (interfaceType != null)
                                {
                                    PropertyDescriptorCollection interfaceDescriptors =
                                        TypeDescriptor.GetProperties(interfaceType, attributes);
                                    PropertyDescriptor interfaceDescriptor = interfaceDescriptors.Find("WordArrangementType", true);
                                    WordArrangementType = (Type)interfaceDescriptor.GetValue(element);
                                }
                            }
                            if (WordArrangementType != null)
                            {
                                PropertyDescriptorCollection WordArrangementDescriptors =
                                    TypeDescriptor.GetProperties(WordArrangementType, attributes);
                                foreach (PropertyDescriptor WordArrangementDescriptor in WordArrangementDescriptors)
                                {
                                    properties.Add(new WordArrangementPropertyDescriptor(WordArrangementDescriptor));
                                }
                            }
                        }
                        else if (elementDescriptor.Name == "LineArrangementDictionary")
                        {
                            Type LineArrangementType = null;
                            {
                                Type interfaceType = element.GetType().GetInterface("IHasLineArrangementDictionary");
                                if (interfaceType != null)
                                {
                                    PropertyDescriptorCollection interfaceDescriptors =
                                        TypeDescriptor.GetProperties(interfaceType, attributes);
                                    PropertyDescriptor interfaceDescriptor = interfaceDescriptors.Find("LineArrangementType", true);
                                    LineArrangementType = (Type)interfaceDescriptor.GetValue(element);
                                }
                            }
                            if (LineArrangementType != null)
                            {
                                PropertyDescriptorCollection LineArrangementDescriptors =
                                    TypeDescriptor.GetProperties(LineArrangementType, attributes);
                                foreach (PropertyDescriptor LineArrangementDescriptor in LineArrangementDescriptors)
                                {
                                    properties.Add(new LineArrangementPropertyDescriptor(LineArrangementDescriptor));
                                }
                            }
                        }
                        else if (elementDescriptor.Name == "PageArrangementDictionary")
                        {
                            Type pageArrangementType = null;
                            {
                                Type interfaceType = element.GetType().GetInterface("IHasPageArrangementDictionary");
                                if (interfaceType != null)
                                {
                                    PropertyDescriptorCollection interfaceDescriptors =
                                        TypeDescriptor.GetProperties(interfaceType, attributes);
                                    PropertyDescriptor interfaceDescriptor = interfaceDescriptors.Find("PageArrangementType", true);
                                    pageArrangementType = (Type)interfaceDescriptor.GetValue(element);
                                }
                            }
                            if (pageArrangementType != null)
                            {
                                PropertyDescriptorCollection pageArrangementDescriptors =
                                    TypeDescriptor.GetProperties(pageArrangementType, attributes);
                                foreach (PropertyDescriptor pageArrangementDescriptor in pageArrangementDescriptors)
                                {
                                    properties.Add(new PageArrangementPropertyDescriptor(pageArrangementDescriptor));
                                }
                            }
                        }
                        else if (elementDescriptor.Name == "BaseFormatName"
                            || elementDescriptor.Name == "BaseWordArrangementName"
                            || elementDescriptor.Name == "BaseLineArrangementName"
                            || elementDescriptor.Name == "BasePageArrangementName")
                        {
                            properties.Add(new PluginBaseNamePropertyDescriptor(elementDescriptor));
                        }
                        else
                        {
                            properties.Add(elementDescriptor);
                        }
                    }
                    return new PropertyDescriptorCollection(properties.ToArray());
                }
            }
            catch (Exception exception)
            {
                Debug.Show(
                    exception,
                    Assembly.GetExecutingAssembly(),
                    MethodBase.GetCurrentMethod());
                return null;
            }
        }

        public override bool GetPropertiesSupported(ITypeDescriptorContext context)
        {
            try
            {
                return true;
            }
            catch (Exception exception)
            {
                Debug.Show(
                    exception,
                    Assembly.GetExecutingAssembly(),
                    MethodBase.GetCurrentMethod());
                return false;
            }
        }
    }
}
