﻿using System;
using System.Collections.Generic;
using System.Reflection;

namespace Kasuga
{
    public class FormatWrapper : PluginWrapper<IFormat>
    {
        public FormatWrapper() : base() { }
        public FormatWrapper(string baseName, IFormat plugin) : base(baseName, plugin) { }

        protected override IFormat GetPluginByName(string name)
        {
            try
            {
                CatalogItem<IFormat> item = CatalogManager.FormatCatalog.Find((CatalogItem<IFormat> listItem) =>
                {
                    return listItem.Name == name;
                });
                return item != null ? (IFormat)item.Plugin.Clone() : null;
            }
            catch (Exception exception)
            {
                Debug.Show(
                    exception,
                    Assembly.GetExecutingAssembly(),
                    MethodBase.GetCurrentMethod());
                return null;
            }
        }
    }
}
