﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Reflection;

namespace Kasuga
{
    public class Elements
    {
        public static string GetBaseFormatName(List<KsgCharacter> characters)
        {
            try
            {
                string name = string.Empty;
                bool isFirst = true;
                foreach (KsgCharacter character in characters)
                {
                    if (isFirst)
                    {
                        isFirst = false;
                        name = character.BaseFormatName;
                    }
                    else
                    {
                        if (name == null || name != character.BaseFormatName)
                        {
                            return string.Empty;
                        }
                    }
                }
                return name;
            }
            catch (Exception exception)
            {
                Debug.Show(
                    exception,
                    Assembly.GetExecutingAssembly(),
                    MethodBase.GetCurrentMethod());
                return string.Empty;
            }
        }

        public static void SetBaseFormatName(List<KsgCharacter> characters, string name)
        {
            try
            {
                if (name != null)
                {
                    foreach (KsgCharacter character in characters)
                    {
                        character.BaseFormatName = name;
                    }
                }
            }
            catch (Exception exception)
            {
                Debug.Show(
                    exception,
                    Assembly.GetExecutingAssembly(),
                    MethodBase.GetCurrentMethod());
            }
        }

        public static IFormat GetBaseFormat(IHasFormatDictionary element)
        {
            try
            {
                CatalogItem<IFormat> item = CatalogManager.FormatCatalog.Find((CatalogItem<IFormat> listItem) =>
                {
                    return listItem.Name == element.BaseFormatName;
                });
                return item != null && item.Plugin != null ? (IFormat)item.Plugin.Clone() : null;
            }
            catch (Exception exception)
            {
                Debug.Show(
                    exception,
                    Assembly.GetExecutingAssembly(),
                    MethodBase.GetCurrentMethod());
                return null;
            }
        }

        public static Type GetFormatType(List<KsgCharacter> characters)
        {
            try
            {
                Type type = null;
                bool isFirst = true;
                foreach (KsgCharacter character in characters)
                {
                    if (isFirst)
                    {
                        isFirst = false;
                        type = character.FormatType;
                    }
                    else
                    {
                        if (type == null || type != character.FormatType)
                        {
                            return null;
                        }
                    }
                }
                return type;
            }
            catch (Exception exception)
            {
                Debug.Show(
                    exception,
                    Assembly.GetExecutingAssembly(),
                    MethodBase.GetCurrentMethod());
                return null;
            }
        }

        public static Dictionary<string, object> GetFormat(List<KsgCharacter> characters)
        {
            try
            {
                Type type = GetFormatType(characters);
                if (type == null)
                {
                    return null;
                }

                Dictionary<string, object> dictionary = new Dictionary<string, object>();
                PropertyDescriptorCollection properties = TypeDescriptor.GetProperties(type);
                foreach (PropertyDescriptor property in properties)
                {
                    object value = null;
                    bool isFirst = true;
                    foreach (KsgCharacter character in characters)
                    {
                        if (isFirst)
                        {
                            isFirst = false;
                            value = property.GetValue(character.Format);
                        }
                        else
                        {
                            if (value == null
                                || !value.Equals(property.GetValue(character.Format)))
                            {
                                value = null;
                                break;
                            }
                        }
                    }
                    dictionary.Add(property.Name, value);
                }
                return dictionary;
            }
            catch (Exception exception)
            {
                Debug.Show(
                    exception,
                    Assembly.GetExecutingAssembly(),
                    MethodBase.GetCurrentMethod());
                return null;
            }
        }

        public static string GetBaseWordArrangementName(List<KsgWord> words)
        {
            try
            {
                string name = string.Empty;
                bool isFirst = true;
                foreach (KsgWord word in words)
                {
                    if (isFirst)
                    {
                        isFirst = false;
                        name = word.BaseWordArrangementName;
                    }
                    else
                    {
                        if (name == null || name != word.BaseWordArrangementName)
                        {
                            return string.Empty;
                        }
                    }
                }
                return name;
            }
            catch (Exception exception)
            {
                Debug.Show(
                    exception,
                    Assembly.GetExecutingAssembly(),
                    MethodBase.GetCurrentMethod());
                return string.Empty;
            }
        }

        public static void SetBaseWordArrangementName(List<KsgWord> words, string name)
        {
            try
            {
                if (name != null)
                {
                    foreach (KsgWord word in words)
                    {
                        word.BaseWordArrangementName = name;
                    }
                }
            }
            catch (Exception exception)
            {
                Debug.Show(
                    exception,
                    Assembly.GetExecutingAssembly(),
                    MethodBase.GetCurrentMethod());
            }
        }

        public static IWordArrangement GetBaseWordArrangement(IHasWordArrangementDictionary element)
        {
            try
            {
                CatalogItem<IWordArrangement> item = CatalogManager.WordArrangementCatalog.Find((CatalogItem<IWordArrangement> listItem) =>
                {
                    return listItem.Name == element.BaseWordArrangementName;
                });
                return item != null && item.Plugin != null ? (IWordArrangement)item.Plugin.Clone() : null;
            }
            catch (Exception exception)
            {
                Debug.Show(
                    exception,
                    Assembly.GetExecutingAssembly(),
                    MethodBase.GetCurrentMethod());
                return null;
            }
        }

        public static Type GetWordArrangementType(List<KsgWord> words)
        {
            try
            {
                Type type = null;
                bool isFirst = true;
                foreach (KsgWord word in words)
                {
                    if (isFirst)
                    {
                        isFirst = false;
                        type = word.WordArrangementType;
                    }
                    else
                    {
                        if (type == null || type != word.WordArrangementType)
                        {
                            return null;
                        }
                    }
                }
                return type;
            }
            catch (Exception exception)
            {
                Debug.Show(
                    exception,
                    Assembly.GetExecutingAssembly(),
                    MethodBase.GetCurrentMethod());
                return null;
            }
        }

        public static Dictionary<string, object> GetWordArrangement(List<KsgWord> words)
        {
            try
            {
                Type type = GetWordArrangementType(words);
                if (type == null)
                {
                    return null;
                }

                Dictionary<string, object> dictionary = new Dictionary<string, object>();
                PropertyInfo[] properties = type.GetProperties();
                foreach (PropertyInfo property in properties)
                {
                    if (property.CanRead)
                    {
                        object value = null;
                        bool isFirst = true;
                        foreach (KsgWord word in words)
                        {
                            if (isFirst)
                            {
                                isFirst = false;
                                value = property.GetValue(word.WordArrangement, null);
                            }
                            else
                            {
                                if (value == null
                                    || !value.Equals(property.GetValue(word.WordArrangement, null)))
                                {
                                    value = null;
                                    break;
                                }
                            }
                        }
                        dictionary.Add(property.Name, value);
                    }
                }
                return dictionary;
            }
            catch (Exception exception)
            {
                Debug.Show(
                    exception,
                    Assembly.GetExecutingAssembly(),
                    MethodBase.GetCurrentMethod());
                return null;
            }
        }

        public static string GetBaseLineArrangementName(List<KsgLine> lines)
        {
            try
            {
                string name = string.Empty;
                bool isFirst = true;
                foreach (KsgLine line in lines)
                {
                    if (isFirst)
                    {
                        isFirst = false;
                        name = line.BaseLineArrangementName;
                    }
                    else
                    {
                        if (name == null || name != line.BaseLineArrangementName)
                        {
                            return string.Empty;
                        }
                    }
                }
                return name;
            }
            catch (Exception exception)
            {
                Debug.Show(
                    exception,
                    Assembly.GetExecutingAssembly(),
                    MethodBase.GetCurrentMethod());
                return string.Empty;
            }
        }

        public static void SetBaseLineArrangementName(List<KsgLine> lines, string name)
        {
            try
            {
                if (name != null)
                {
                    foreach (KsgLine line in lines)
                    {
                        line.BaseLineArrangementName = name;
                    }
                }
            }
            catch (Exception exception)
            {
                Debug.Show(
                    exception,
                    Assembly.GetExecutingAssembly(),
                    MethodBase.GetCurrentMethod());
            }
        }

        public static ILineArrangement GetBaseLineArrangement(IHasLineArrangementDictionary element)
        {
            try
            {
                CatalogItem<ILineArrangement> item = CatalogManager.LineArrangementCatalog.Find((CatalogItem<ILineArrangement> listItem) =>
                {
                    return listItem.Name == element.BaseLineArrangementName;
                });
                return item != null && item.Plugin != null ? (ILineArrangement)item.Plugin.Clone() : null;
            }
            catch (Exception exception)
            {
                Debug.Show(
                    exception,
                    Assembly.GetExecutingAssembly(),
                    MethodBase.GetCurrentMethod());
                return null;
            }
        }

        public static Type GetLineArrangementType(List<KsgLine> lines)
        {
            try
            {
                Type type = null;
                bool isFirst = true;
                foreach (KsgLine line in lines)
                {
                    if (isFirst)
                    {
                        isFirst = false;
                        type = line.LineArrangementType;
                    }
                    else
                    {
                        if (type == null || type != line.LineArrangementType)
                        {
                            return null;
                        }
                    }
                }
                return type;
            }
            catch (Exception exception)
            {
                Debug.Show(
                    exception,
                    Assembly.GetExecutingAssembly(),
                    MethodBase.GetCurrentMethod());
                return null;
            }
        }

        public static Dictionary<string, object> GetLineArrangement(List<KsgLine> lines)
        {
            try
            {
                Type type = GetLineArrangementType(lines);
                if (type == null)
                {
                    return null;
                }

                Dictionary<string, object> dictionary = new Dictionary<string, object>();
                PropertyInfo[] properties = type.GetProperties();
                foreach (PropertyInfo property in properties)
                {
                    if (property.CanRead)
                    {
                        object value = null;
                        bool isFirst = true;
                        foreach (KsgLine line in lines)
                        {
                            if (isFirst)
                            {
                                isFirst = false;
                                value = property.GetValue(line.LineArrangement, null);
                            }
                            else
                            {
                                if (value == null
                                    || !value.Equals(property.GetValue(line.LineArrangement, null)))
                                {
                                    value = null;
                                    break;
                                }
                            }
                        }
                        dictionary.Add(property.Name, value);
                    }
                }
                return dictionary;
            }
            catch (Exception exception)
            {
                Debug.Show(
                    exception,
                    Assembly.GetExecutingAssembly(),
                    MethodBase.GetCurrentMethod());
                return null;
            }
        }

        public static string GetBasePageArrangementName(List<KsgPage> pages)
        {
            try
            {
                string name = string.Empty;
                bool isFirst = true;
                foreach (KsgPage page in pages)
                {
                    if (isFirst)
                    {
                        isFirst = false;
                        name = page.BasePageArrangementName;
                    }
                    else
                    {
                        if (name == null || name != page.BasePageArrangementName)
                        {
                            return string.Empty;
                        }
                    }
                }
                return name;
            }
            catch (Exception exception)
            {
                Debug.Show(
                    exception,
                    Assembly.GetExecutingAssembly(),
                    MethodBase.GetCurrentMethod());
                return string.Empty;
            }
        }

        public static void SetBasePageArrangementName(List<KsgPage> pages, string name)
        {
            try
            {
                if (name != null)
                {
                    foreach (KsgPage page in pages)
                    {
                        page.BasePageArrangementName = name;
                    }
                }
            }
            catch (Exception exception)
            {
                Debug.Show(
                    exception,
                    Assembly.GetExecutingAssembly(),
                    MethodBase.GetCurrentMethod());
            }
        }

        public static IPageArrangement GetBasePageArrangement(IHasPageArrangementDictionary element)
        {
            try
            {
                CatalogItem<IPageArrangement> item = CatalogManager.PageArrangementCatalog.Find((CatalogItem<IPageArrangement> listItem) =>
                {
                    return listItem.Name == element.BasePageArrangementName;
                });
                return item != null && item.Plugin != null ? (IPageArrangement)item.Plugin.Clone() : null;
            }
            catch (Exception exception)
            {
                Debug.Show(
                    exception,
                    Assembly.GetExecutingAssembly(),
                    MethodBase.GetCurrentMethod());
                return null;
            }
        }

        public static Type GetPageArrangementType(List<KsgPage> pages)
        {
            try
            {
                Type type = null;
                bool isFirst = true;
                foreach (KsgPage page in pages)
                {
                    if (isFirst)
                    {
                        isFirst = false;
                        type = page.PageArrangementType;
                    }
                    else
                    {
                        if (type == null || type != page.PageArrangementType)
                        {
                            return null;
                        }
                    }
                }
                return type;
            }
            catch (Exception exception)
            {
                Debug.Show(
                    exception,
                    Assembly.GetExecutingAssembly(),
                    MethodBase.GetCurrentMethod());
                return null;
            }
        }

        public static Dictionary<string, object> GetPageArrangement(List<KsgPage> pages)
        {
            try
            {
                Type type = GetPageArrangementType(pages);
                if (type == null)
                {
                    return null;
                }

                Dictionary<string, object> dictionary = new Dictionary<string, object>();
                PropertyInfo[] properties = type.GetProperties();
                foreach (PropertyInfo property in properties)
                {
                    if (property.CanRead)
                    {
                        object value = null;
                        bool isFirst = true;
                        foreach (KsgPage page in pages)
                        {
                            if (isFirst)
                            {
                                isFirst = false;
                                value = property.GetValue(page.PageArrangement, null);
                            }
                            else
                            {
                                if (value == null
                                    || !value.Equals(property.GetValue(page.PageArrangement, null)))
                                {
                                    value = null;
                                    break;
                                }
                            }
                        }
                        dictionary.Add(property.Name, value);
                    }
                }
                return dictionary;
            }
            catch (Exception exception)
            {
                Debug.Show(
                    exception,
                    Assembly.GetExecutingAssembly(),
                    MethodBase.GetCurrentMethod());
                return null;
            }
        }
    }
}
