﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Reflection;
using System.Text;
using System.Text.RegularExpressions;

namespace Kasuga.Ass
{
    public class AssFile
    {
        public string Title { get; set; }
        public string ScriptType { get { return "v4.00+"; } }
        public int WrapStyle { get; set; }
        public int PlayResX { get; set; }
        public int PlayResY { get; set; }
        public List<AssStyle> Styles { get; set; }
        public List<AssEvent> Events { get; set; }

        private const string SCRIPT_INFO_HEADER = "[Script Info]";
        private const string STYLES_HEADER = "[V4+ Styles]";
        private const string EVENTS_HEADER = "[Events]";

        public void Save(string fileName)
        {
            try
            {
                StreamWriter writer = new StreamWriter(fileName, false, Encoding.UTF8);
                writer.WriteLine(SCRIPT_INFO_HEADER);
                writer.WriteLine("; Script generated by Kasuga");
                //writer.WriteLine("; Script generated by Kasuga " + version);
                writer.WriteLine("; http://sourceforge.jp/projects/kasuga/");
                writer.WriteLine(Title);
                writer.WriteLine(ScriptType);
                writer.WriteLine(WrapStyle);
                writer.WriteLine(PlayResX);
                writer.WriteLine(PlayResY);
                writer.WriteLine();
                writer.WriteLine(STYLES_HEADER);
                writer.WriteLine(
                    "Format: Name, Fontname, Fontsize, "
                    + "PrimaryColour, SecondaryColour, "
                    + "OutlineColour, BackColour, "
                    + "Bold, Italic, Underline, StrikeOut, "
                    + "ScaleX, ScaleY, Spacing, Angle, "
                    + "BorderStyle, Outline, Shadow, Alignment, "
                    + "MarginL, MarginR, MarginV, Encoding");
                foreach (AssStyle style in Styles)
                {
                    writer.WriteLine(style.ToLine());
                }
                writer.WriteLine();
                writer.WriteLine(EVENTS_HEADER);
                writer.WriteLine(
                    "Format: Layer, Start, End, Style, Name, "
                    + "MarginL, MarginR, MarginV, Effect, Text");
                foreach (AssEvent ev in Events)
                {
                    writer.WriteLine(ev.ToLine());
                }

                writer.Flush();
                writer.Close();
            }
            catch (Exception exception)
            {
                Debug.Show(
                    exception,
                    Assembly.GetExecutingAssembly(),
                    MethodBase.GetCurrentMethod());
            }
        }
    }
}
