﻿using System;
using System.Reflection;
using System.Text;
using System.Text.RegularExpressions;

namespace Kasuga.Ass
{
    public class AssEvent
    {
        public AssEvent(
            AssEventKind kind,
            int layer,
            PlayTime start,
            PlayTime end,
            string styleName,
            string actor,
            int marginL,
            int marginR,
            int marginV,
            string effect,
            string text)
        {
            try
            {
                Kind = kind;
                Layer = layer;
                Start = start;
                End = end;
                StyleName = styleName;
                Actor = actor;
                MarginL = marginL;
                MarginR = marginR;
                MarginV = marginV;
                Effect = effect;
                Text = text;
            }
            catch (Exception exception)
            {
                Debug.Show(
                    exception,
                    Assembly.GetExecutingAssembly(),
                    MethodBase.GetCurrentMethod());
            }
        }

        public AssEventKind Kind { get; set; }
        public int Layer { get; set; }
        public PlayTime Start { get; set; }
        public PlayTime End { get; set; }
        public string StyleName { get; set; }
        public string Actor { get; set; }
        public int MarginL { get; set; }
        public int MarginR { get; set; }
        public int MarginV { get; set; }
        public string Effect { get; set; }
        public string Text { get; set; }

        public string ToLine()
        {
            try
            {
                StringBuilder builder = new StringBuilder();
                switch (Kind)
                {
                    case AssEventKind.Dialogue:
                        builder.Append("Dialogue: ");
                        break;
                    case AssEventKind.Comment:
                        builder.Append("Comment: ");
                        break;
                    case AssEventKind.Picture:
                        builder.Append("Picture: ");
                        break;
                    case AssEventKind.Sound:
                        builder.Append("Sound: ");
                        break;
                    case AssEventKind.Movie:
                        builder.Append("Movie: ");
                        break;
                    case AssEventKind.Command:
                        builder.Append("Command: ");
                        break;
                }
                builder.Append(Layer);
                builder.Append(",");
                builder.Append(Start.ToAssTimeString());
                builder.Append(",");
                builder.Append(End.ToAssTimeString());
                builder.Append(",");
                builder.Append(StyleName);
                builder.Append(",");
                builder.Append(Actor);
                builder.Append(",");
                builder.Append(MarginL.ToString("D4"));
                builder.Append(",");
                builder.Append(MarginR.ToString("D4"));
                builder.Append(",");
                builder.Append(MarginV.ToString("D4"));
                builder.Append(",");
                builder.Append(Effect);
                builder.Append(",");
                builder.Append(Text);
                return builder.ToString();
            }
            catch (Exception exception)
            {
                Debug.Show(
                    exception,
                    Assembly.GetExecutingAssembly(),
                    MethodBase.GetCurrentMethod());
                return string.Empty;
            }
        }
    }
}
