// Kasuga.DirectShow.h

#pragma once
#include <DShow.h>

using namespace System;

namespace Kasuga
{
	namespace DirectShow
	{
		public enum FilterStateKind
		{
			Stopped,
			Paused,
			Running
		};

		public ref class AudioPlayer
		{
		private:
			IGraphBuilder* _graphBuilder;
			IMediaControl* _mediaControl;
			IMediaEventEx* _mediaEventEx;
			IMediaSeeking* _mediaSeeking;
			IBasicAudio* _basicAudio;
			OAHWND _hwnd;
			int _wmGraphNotify;

		public:
			AudioPlayer(IntPtr hwnd, int wmGraphNotify);
			~AudioPlayer();
			!AudioPlayer();

			property FilterStateKind FilterState
			{
				FilterStateKind get();
			}
			property PlayTimeSpan^ Duration
			{
				PlayTimeSpan^ get();
			}
			property PlayTime^ CurrentPosition
			{
				PlayTime^ get();
				void set(PlayTime^ value);
			}
			property double Rate
			{
				double get();
				void set(double value);
			}
			property double Volume
			{
				double get();
				void set(double value);
			}

			bool OpenFile(String^ fileName);
			void Run();
			void Pause();
			void Stop();
			void OnEvent(IntPtr wParam, IntPtr lParam, bool% complete);
		};
	}
}