# -*- coding: utf-8 -*-
#
# This file is part of Karesansui.
#
# Copyright (C) 2009-2010 HDE, Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#

import os.path
import re
import glob
import time

import web
import simplejson as json

import karesansui
from karesansui.lib.rest import Rest, auth

from karesansui.lib.utils import chk_create_disk, json_dumps, is_param, base64_decode
from karesansui.lib.const import \
    VIRT_COMMAND_IMPORT_GUEST, \
    VIRT_COMMAND_DELETE_EXPORT_DATA, \
    VIRT_DOMAINS_DIR

from karesansui.lib.virt.virt import KaresansuiVirtConnection

from karesansui.db.access._2pysilhouette import save_job_collaboration
from karesansui.db.access.machine2jobgroup import new as m2j_new
from karesansui.db.access.notebook import findby1 as n_findby1
from karesansui.db.access.machine  import findbyhost1

from pysilhouette.command import dict2command
from karesansui.db.model._2pysilhouette import Job, JobGroup

from karesansui.lib.checker import Checker, \
    CHECK_EMPTY, CHECK_VALID, CHECK_ISDIR, CHECK_STARTROOT, CHECK_EXIST

from karesansui.lib.utils import get_xml_parse        as XMLParse
from karesansui.lib.utils import get_xml_xpath        as XMLXpath
from karesansui.lib.utils import get_nums_xml_xpath   as XMLXpathNum
from karesansui.lib.file.configfile import ConfigFile

def validates_guest_import(obj):
    checker = Checker()
    check = True

    _ = obj._
    checker.errors = []

    if not is_param(obj.input, 'export_dir'):
        check = False
        checker.add_error(_('Parameter export_dir does not exist.'))
    else:
        check = checker.check_directory(
                _('Export Data'),
                obj.input.export_dir,
                CHECK_EMPTY|CHECK_VALID|CHECK_ISDIR|CHECK_STARTROOT|CHECK_EXIST,
            ) and check

    obj.view.alert = checker.errors
    return check


class HostBy1GuestExportBy1(Rest):

    @auth
    def _GET(self, *param, **params):

        #import pdb; pdb.set_trace()
        host_id = self.chk_hostby1(param)
        if host_id is None: return web.notfound()

        #if self.is_mode_input() is False:
        #    return web.nomethod()

        export_dir = base64_decode(str(param[1]))

        self.view.info = {}

        paths = {}
        kvc = KaresansuiVirtConnection()
        try:
            active_pools   = kvc.list_active_storage_pool()
            inactive_pools = kvc.list_inactive_storage_pool()

            all_pools = sorted(active_pools + inactive_pools)
            for pool_name in all_pools:
                try:
                    pool = kvc.search_kvn_storage_pools(pool_name)
                    path = pool[0].get_info()["target"]["path"]
                    paths[path] = pool_name
                except:
                    pass
        finally:
            kvc.close()

        info_file = "%s/info.xml" % (export_dir)
        if os.path.exists(info_file):
            doc = XMLParse("".join(ConfigFile(info_file).read()))
            uuid    = XMLXpath(doc,'/export/@id')
            name    = XMLXpath(doc,'/export/domain/text()')
            created = XMLXpath(doc,'/export/created/text()')
            title   = XMLXpath(doc,'/export/title/text()')
            notebook_id = XMLXpath(doc,'/export/extra/notebook_id/text()')
            if title != "":
                title = re.sub("[\r\n]","",title)
            if title == "":
                title = _('untitled')

            if created != "":
                created_str = time.strftime("%Y/%m/%d %H:%M:%S",time.localtime(float(created)))
            else:
                created_str = _("N/A")

            p_dir = os.path.dirname(export_dir)
            try:
                pool_name = paths[p_dir]
            except:
                pool_name = _("N/A")

            try:
                notebook = n_findby1(self.orm, notebook_id)
            except:
                notebook = None

            self.view.info = {
                             "b64dir"  :str(param[1]),
                             "dir"     :export_dir,
                             "pool_name":pool_name,
                             "uuid"    :uuid,
                             "name"    :name,
                             "created" :int(created),
                             "created_str" :created_str,
                             "title"   :title,
                             "notebook" :notebook,
                              }

        return True


    @auth
    def _DELETE(self, *param, **params):
        host_id = self.chk_hostby1(param)
        if host_id is None: return web.notfound()

        export_dir = base64_decode(str(param[1]))
        if not (export_dir and host_id):
            return web.badrequest()

        if os.path.exists(export_dir) is False or os.path.isdir(export_dir) is False:
            return web.badrequest(_('Export data is not valid. [%s]') % export_dir)

        host = findbyhost1(self.orm, host_id)

        options = {}
        options['dir'] = export_dir
        export_data_id = os.path.basename(export_dir)

        _cmd = dict2command(
            "%s/%s" % (karesansui.config['application.bin.dir'], VIRT_COMMAND_DELETE_EXPORT_DATA), options)
            
        # Job Registration
        _jobgroup = JobGroup('Delete export data: %s' % export_data_id, karesansui.sheconf['env.uniqkey'])
        _jobgroup.jobs.append(Job('Delete export data', 0, _cmd))
            
        _machine2jobgroup = m2j_new(machine=host,
                                    jobgroup_id=-1,
                                    uniq_key=karesansui.sheconf['env.uniqkey'],
                                    created_user=self.me,
                                    modified_user=self.me,
                                    )
            
        save_job_collaboration(self.orm,
                               self.pysilhouette.orm,
                               _machine2jobgroup,
                               _jobgroup,
                               )
        
        self.logger.debug('(Delete export data) Job group id==%s', _jobgroup.id)
        url = '%s/job/%s.part' % (web.ctx.home, _jobgroup.id)
        self.logger.debug('Returning Location: %s' % url)

        return web.accepted()


urls = (
    '/host/(\d+)/guestexport/([a-zA-Z0-9\=]{2,})/?(\.part|\.json)?$', HostBy1GuestExportBy1,
    )
