#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
# This file is part of Karesansui.
#
# Copyright (C) 2009-2010 HDE, Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#

import os
import os.path
import sys
import signal
import logging
from optparse import OptionParser

from ksscommand import KssCommand, KssCommandException, KssCommandOptException

import __cmd__

try:
    import karesansui
    from karesansui import __version__
    from karesansui.lib.virt.virt import KaresansuiVirtConnection, KaresansuiVirtException
    from karesansui.lib.utils import load_locale
    from karesansui.lib.const import VIRT_DOMAINS_DIR
except ImportError:
    print >>sys.stderr, "[Error] karesansui package was not found."
    sys.exit(1)

_ = load_locale()

usage = '%prog [options]'

def getopts():
    optp = OptionParser(usage=usage, version=__version__)
    optp.add_option('-d', '--dir',  dest='dir',  help=_('Directory name'))
    optp.add_option('-u', '--uuid', dest='uuid', help=_('UUID'), default=None)
    optp.add_option('-q', '--quiet',dest='verbose', action="store_false", default=True, help=_("don't print status messages"))

    return optp.parse_args()

def chkopts(opts):
    if not opts.dir:
        raise KssCommandOptException('ERROR: -d or --dir option is required.')

class ImportGuest(KssCommand):

    def process(self):
        (opts, args) = getopts()
        chkopts(opts)
        self.up_progress(1)

        from karesansui.lib.utils import preprint_r
        conn = KaresansuiVirtConnection(readonly=False)
        try:
            progresscb = None
            if opts.verbose:
                try:
                    from karesansui.lib.progress import ProgressMeter
                    progresscb = ProgressMeter(command_object=self)
                except:
                    pass
            else:
                try:
                    from karesansui.lib.progress import ProgressMeter
                    progresscb = ProgressMeter(command_object=self,quiet=True)
                except:
                    pass
    
            conn.import_guest(opts.dir, uuid=opts.uuid, progresscb=progresscb)

            self.up_progress(40)

        except KaresansuiVirtException, e:
            self.logger.error('Failed to import guest. - [%s]' % (''.join(e.args)))
            raise
        except:
            self.logger.error('Failed to import guest.')
            raise

        return True

if __name__ == "__main__":
    target = ImportGuest()
    sys.exit(target.run())
