#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# This file is part of Karesansui.
#
# Copyright (C) 2010 HDE, Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#

import os
import sys
import logging
from optparse import OptionParser

from ksscommand import KssCommand, KssCommandException, KssCommandOptException

import __cmd__

try:
    import karesansui
    from karesansui import __version__
    from karesansui.lib.virt.virt import KaresansuiVirtConnection
    from karesansui.lib.utils import load_locale
except ImportError:
    print >>sys.stderr, "[Error] karesansui package was not found."
    sys.exit(1)

_ = load_locale()

usage = '%prog [options]'

def getopts():
    optp = OptionParser(usage=usage, version=__version__)
    optp.add_option('-n', '--name', dest='name', help=_('Storage volume name'))
    optp.add_option('-p', '--pool_name', dest='pool_name', help=_('Storage pool name'))
    return optp.parse_args()

def chkopts(opts):
    if not opts.name:
        raise KssCommandOptException('ERROR: %s option is required.' % '-n or --name')
    if not opts.pool_name:
        raise KssCommandOptException('ERROR: %s option is required.' % '-p or --pool_name')
 
class DeleteStorageVolume(KssCommand):

    def process(self):
        (opts, args) = getopts()
        chkopts(opts)
        self.up_progress(10)
        
        conn = KaresansuiVirtConnection(readonly=False)

        try:
            inactive_storage_pools = conn.list_inactive_storage_pool()
            active_storage_pools = conn.list_active_storage_pool()
            self.up_progress(10)

            if not (opts.pool_name in active_storage_pools or \
                   opts.pool_name in inactive_storage_pools):
                raise KssCommandException('Storage pool does not exist. - pool=%s'
                                          % opts.name)

            if conn.get_storage_volume(opts.pool_name, opts.name) is None:
                raise KssCommandException(
                    'Specified storage volume does not exist. - pool=%s, vol=%s'
                    % (opts.pool_name, opts.name))

            try:
                self.up_progress(30)
                if conn.delete_storage_volume(opts.pool_name, opts.name, True) is False:
                    KssCommandException("Failed to destroy storage volume. (libvirt)- pool=%s, vol=%s" \
                                        % (opts.pool_name, opts.name))
                
                self.up_progress(30)
                self.logger.info('Deleted storage volume. - vol=%s' % (opts.name))
                print >>sys.stdout, _('Deleted storage volume. - vol=%s') % (opts.name)
                return True
            except KssCommandException, e:
                raise e
        finally:
            conn.close()
        
if __name__ == "__main__":
    target = DeleteStorageVolume()
    sys.exit(target.run())
