#!/bin/sh
#
# This file is part of Karesansui.
#
# Copyright (C) 2009-2010 HDE, Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#

suffix=.git
kss_group=kss

rpm -Uvh ftp://centos5x86.prd.local.hde.co.jp/common/perl-Error-0.17010-1.el5.noarch.rpm

yum --enablerepo=karesansui-devel -y install hde-graphviz hde-libvirt-devel hde-graphviz-gd hde-python-epydoc hde-python-Beaker hde-python-setuptools hde-python-Babel emacs-Pymacs emacs-epydoc emacs-js2 emacs-python-mode emacs-yasnippet

# gitをインストール
yum -y install perl-DBI
rpm -Uvh ftp://centos5x86.prd.local.hde.co.jp/pkgs/git/RPMS/i386/git-1*.rpm ftp://centos5x86.prd.local.hde.co.jp/pkgs/git/RPMS/i386/perl-Git*.rpm

# emacs pdbモードで利用する
if [ ! -e /usr/bin/pdb ]; then
  cat <<_EOT_ >/usr/bin/pdb
#!/bin/sh
exec python /usr/lib/python2.4/pdb.py \$1 \$2 \$3 \$4 \$5 \$6 \$7 \$8 \$9

_EOT_
  chmod +x /usr/bin/pdb
fi

# gitリポジトリから取り寄せ

#mv -i /opt/karesansui/lib/python/karesansui /opt/karesansui/lib/python/karesansui.orig
#mv -i /etc/opt/karesansui /etc/opt/karesansui.orig && mkdir /etc/opt/karesansui
#mv -i /opt/karesansui/bin /opt/karesansui/bin.orig && mkdir /opt/karesansui/bin
rm -fr /opt/karesansui/lib/python/karesansui
rm -fr /etc/opt/karesansui && mkdir /etc/opt/karesansui

if [ ! -e /opt/karesansui/lib/python/karesansui ]; then
  mkdir -p /opt/karesansui/lib/python

  echo -n "Please input your account on 'raid.local.hde.co.jp' :"
  read username

  chmod 755 $HOME
  git_dir=$HOME/karesansui$suffix
  rm -fr $git_dir

  pushd $HOME
  git clone ssh://${username}@raid.local.hde.co.jp/hde/karesansui/karesansui.git karesansui$suffix
  popd

  # 設定ファイルコピー
  if [ ! -e /opt/karesansui/lib/python/karesansui ]; then
  ln -s $git_dir/karesansui /opt/karesansui/lib/python/karesansui
  fi
  if [ ! -e /etc/opt/karesansui/application.conf ]; then
  cp $git_dir/doc/application.conf.example /etc/opt/karesansui/application.conf
  cp $git_dir/doc/log.conf /etc/opt/karesansui/
  sed -e "s#^application.log.config=.*#application.log.config=/etc/opt/karesansui/log.conf#" /etc/opt/karesansui/application.conf >/etc/opt/karesansui/application.conf.$$
  cp -f /etc/opt/karesansui/application.conf.$$ /etc/opt/karesansui/application.conf
  rm -f /etc/opt/karesansui/application.conf.$$
  fi

  rm -fr /opt/karesansui/bin
  ln -s $git_dir/bin /opt/karesansui/bin
  ln -s $git_dir/scripts/karesansui.fcgi /opt/karesansui/bin/

  chgrp -R ${kss_group} $git_dir
  chmod -R g+w $git_dir

  /etc/init.d/hde-lighttpd restart
fi
chgrp -R ${kss_group} /etc/opt/karesansui
chgrp -R ${kss_group} /opt/karesansui
chmod -R g+w /etc/opt/karesansui
chmod -R g+w /opt/karesansui

#########################
# その他のパッケージのインストール

yum -y install hde-python-virtinst hde-virt-manager
yum -y install wxPython-common-gtk2-unicode wxPython2.8-gtk2-unicode python-crypto winpdb

user_name=`git config user.name`
user_email=`git config user.email`
if [ "${user_name}" = "" ]; then
  echo -n "Please input username (like as '[1mNamae MYOJI[0m'): "
  read user_name
  git config --global user.name ${user_name}
fi
if [ "${user_email}" = "" ]; then
  echo -n "Please input email address (like as '[1muser@hde.co.jp[0m'): "
  read user_email
  git config --global user.email ${user_email}
fi
