#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
# This file is part of Karesansui Core.
#
# Copyright (C) 2010 HDE, Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU Lesser General Public
# License as published by the Free Software Foundation; either
# version 2.1 of the License, or (at your option) any later version.
#

from karesansui.db.model.watchdetail import Watchdetail
from karesansui.db.access import dbsave, dbupdate, dbdelete

# -- all
def findbyall(session):
    return session.query(Watchdetail).all()

def findby1(session, watchdetail_id):
    return session.query(Watchdetail).filter(
        Watchdetail.id == watchdetail_id).first()

def findbywatch(session, watch_id):
    return session.query(Watchdetail).filter(
        Watchdetail.watch_id == watch_id).all()

@dbsave
def save(session, watchdetail):
    session.save(watchdetail)

@dbupdate
def update(session, watchdetail):
    session.update(watchdetail)

@dbdelete
def delete(session, watchdetail):
    session.delete(watchdetail)

# new instance
new = Watchdetail

def test(session):
    from karesansui.db.access.user import findby1 as user_findby1
    user = user_findby1(session, 1)
    from karesansui.db.access.watch import findby1 as watch_findby1
    watch = watch_findby1(session, 1)
    from karesansui.db.access.mailtemplate import findby1 as mailtemplate_findby1
    _mailtemplate = mailtemplate_findby1(session, 2)
    import os
    shell = """#!/bin/bash
echo "shell"
"""
    value_selector = """<Match>
reg hoge
</Match>"""
    watchdetail = Watchdetail(created_user=user,
                                            modified_user=user,
                                            watch=watch,
                                            value_selector=value_selector,
                                            shell=shell)

    save(session, watchdetail)
    session.commit()
    _all = findbyall(session)
    _findby1 = findby1(session, watchdetail.id)
    import pdb; pdb.set_trace()

if __name__ == '__main__':
    test()
