#!/usr/bin/env python
# -*- coding: utf-8 -*-
#
# This file is part of Karesansui.
#
# Copyright (C) 2009-2010 HDE, Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#

import os
import os.path
import sys
import shutil
import glob
import logging
from optparse import OptionParser

from ksscommand import KssCommand, KssCommandException, KssCommandOptException

import __cmd__

try:
    import karesansui
    from karesansui import __version__
    from karesansui.lib.virt.virt import KaresansuiVirtConnection, KaresansuiVirtException
    from karesansui.lib.utils import load_locale
    from karesansui.lib.const import VIRT_DOMAINS_DIR
except ImportError:
    print >>sys.stderr, "[Error] karesansui package was not found."
    sys.exit(1)

_ = load_locale()

usage = '%prog [options]'

def getopts():
    optp = OptionParser(usage=usage, version=__version__)
    optp.add_option('-d', '--dir',  dest='dir',  help=_('Directory name'))
    optp.add_option('-q', '--quiet',dest='verbose', action="store_false", default=True, help=_("don't print status messages"))

    return optp.parse_args()

def chkopts(opts):
    if not opts.dir:
        raise KssCommandOptException('ERROR: -d or --dir option is required.')

class DeleteExportData(KssCommand):

    def process(self):
        (opts, args) = getopts()
        chkopts(opts)
        self.up_progress(1)

        if os.path.exists(opts.dir) is True and os.path.exists(opts.dir) is True:
            uuid = os.path.basename(opts.dir)
            pool_dir = os.path.dirname(opts.dir)

            from karesansui.lib.utils import is_uuid
            if is_uuid(uuid):
                shutil.rmtree(opts.dir)

                for _afile in glob.glob("%s*img" % (opts.dir,)):
                    os.remove(_afile)

                # refresh pool.
                conn = KaresansuiVirtConnection(readonly=False)
                try:
                    active_pools   = conn.list_active_storage_pool()
                    inactive_pools = conn.list_inactive_storage_pool()
                    for pool_name in active_pools + inactive_pools:
                        try:
                            pool = conn.search_kvn_storage_pools(pool_name)
                            path = pool[0].get_info()["target"]["path"]
                            if pool_dir == path:
                                conn.search_storage_pools(pool_name)[0].refresh(True)
                        except:
                            pass
                finally:
                    conn.close()

                log_msg = _("Delete export data '%s'.") % (uuid,)
                self.logger.info(log_msg)
                print >>sys.stderr, log_msg

            else:
                log_msg = _("'%s' is not valid export data directory.") % (opts.dir,)
                self.logger.error(log_msg)
                raise KssCommandException(
                    _("Failed to delete export data. - %s") % (log_msg,))
        else:
            log_msg = _("Export data directory not found. [%s]") % (opts.dir,)
            self.logger.error(log_msg)
            raise KssCommandException(
                _("Failed to delete export data. - %s") % (log_msg,))


        return True

if __name__ == "__main__":
    target = DeleteExportData()
    sys.exit(target.run())
