=begin
  CaptchaImage : Download captcha image
  Copyright(C) 2008 FUKUOKA Tomoyuki.

  This file is part of KAGEMAI.  

  KAGEMAI is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
=end

require 'kagemai/util'
require 'kagemai/error'
require 'kagemai/cgi/action'
require 'kagemai/cgi/captcha'

module Kagemai  
  class CaptchaImage < Action
    include CaptchaHandler
    
    def execute()
      begin
        @session = @cgi.create_session()
      rescue ArgumentError 
        unless $KAGEMAI_DEBUG then
          raise SecurityError, 'no captcha image'
        else
          # for test
          @session = @cgi.create_session('session_id' => @cgi.get_param('sid'))
          raise ParameterError unless @session
        end
      end
      
      image = get_captcha_image()
      CaptchaImageResult.new(image)
    end
    
    def self.name()
      'captcha'
    end
    Action::add_action(self)
  end
  
  class CaptchaImageResult
    def initialize(image)
      @image = image
    end

    def respond(cgi, flush_log, show_env, out = $stdout)
      $stdout.print http_header(cgi, @image.size)
      http_body_with_print(cgi, flush_log, show_env, out)
    end

    def http_header(cgi, length)
      if defined?(MOD_RUBY) then
        Apache::request.headers_out.clear
      end
      
      opts = {
        'status'  => 'OK',
        'type'    => 'image/jpeg',
        'length'  => length,
        'Pragma'  => 'no-cache',
        'Expires' => Time.now,
        'Cache-Control' => 'no-cache'
      }
      
      cgi.header(opts)
    end
      
    def http_body_with_print(cgi, flush_log, show_env, out = $stdout)
      print @image
    end
    
  end
end
