require 'runit/testcase'
require 'kagemai/message_bundle'

class TestMessageBundle < RUNIT::TestCase
  include Kagemai

  def setup()
    @messages = <<-MESSAGES
    # skip this
    test_key1 = hello world
    test_key2 = hello world2
    test_key3 = hello = world
    MESSAGES

    @mb = MessageBundle.new(@messages)    
  end

  def test_get_message()
    assert_equals('hello world', @mb[:test_key1])
  end

  def test_get_message2()
    assert_exception(NoSuchResourceError) {
      @mb[:test_key4]
    }
  end

  def test_get_message_3()
    MessageBundle.open('test/testfile/message', 'ja', 'testmessage')
    assert_equals('hello world', MessageBundle[:test_key1])
  end

  def test_get_message4()
    assert_equals('hello = world', @mb[:test_key3])
  end

  def test_update()
    messages2 = <<-MESSAGES2
    # skip this
    test_key1 = hello world3
    test_key3 = hello = world5
    MESSAGES2

    @mb.update(messages2)

    assert_equals('hello world3', @mb[:test_key1])
    assert_equals('hello world2', @mb[:test_key2])
    assert_equals('hello = world5', @mb[:test_key3])
  end
end

