require 'runit/testcase'
require 'kagemai/fold'

class TestFold < RUNIT::TestCase
  include Kagemai

  def test_fold_ascii
    #         1234567890123456789012345
    input  = 'this is a long long line.'
    expect = "this is a \nlong long \nline."
    assert_equals(expect, Fold::fold_line(input, 12))
  end

  def test_fold_ascii2
    #         1234567890123456789012345
    input  = 'this is a long-long line.'
    expect = "this is a long-\nlong line."
    assert_equals(expect, Fold::fold_line(input, 16))
  end

  def test_fold_jp
    #         1234567890123456789012345
    input  = '礦ϤŷǤ'
    expect = "礦Ϥ\nŷǤ"
    assert_equals(expect, Fold::fold_line(input, 12))
  end

  # Ƭ§
  def test_fold_jp2
    #         1234567890123456789012345
    input  = 'Ϥ͡'
    expect = "Ϥ\n͡"
    assert_equals(expect, Fold::fold_line(input, 12))
  end

  # §
  def test_fold_jp3
    #         1234567890123456789012345
    input  = 'Ϥŷ'
    expect = "Ϥ\nŷ"
    assert_equals(expect, Fold::fold_line(input, 12))
  end

  # ܸ 1byte ܤ 2byte ܤδ֤礦ޤ֤߰ξ
  def test_fold_jp4
    input2  = 'a礦ϤŷǤ'
    expect2 = "a礦Ϥ\nŷǤ"
    assert_equals(expect2, Fold::fold_line(input2, 12))
  end

  # Ƭ§2
  def test_fold_jp5
    #         1234567890123456789012345
    input  = 'aϤ͡'
    expect = "aϤ\n͡"
    assert_equals(expect, Fold::fold_line(input, 12))
  end

  # §2
  def test_fold_jp6
    #         1234567890123456789012345
    input  = 'aϤŷ'
    expect = "aϤ\nŷ"
    assert_equals(expect, Fold::fold_line(input, 12))
  end

  def test_fold_lines
    input = <<INPUT
this is a long long line.
ϤȤäƤ⤤ŷǤ͡
INPUT

    expect = <<EXPECT
this is a long 
long line.
ϤȤäƤ⤤
ŷǤ͡
EXPECT

    assert_equals(expect, Fold::fold(input, 16))
  end
end
