=begin
  kagemai.rb -- KAGEMAI : A Bug Tracking System.

  Copyright(C) 2002-2004 FUKUOKA Tomoyuki.

  This file is part of KAGEMAI.  

  KAGEMAI is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  $Id: kagemai.rb 69 2004-08-15 08:29:45Z  $
=end

require 'kagemai/config'
require 'kagemai/bts'
require 'kagemai/cgi/action'
require 'kagemai/error'

module Kagemai
  CODENAME = 'Shima'
  VERSION  =  '0.8.4'
  URL      = 'http://www.daifukuya.com/kagemai/'
  
  class CGIApplication
    def self.instance()
      # Get applicatoin object from TLS.
      application = Thread.current[:CGIApplication]
      unless application
        raise Error, 'cannnot retrieve CGIApplication object from TLS.'
      end
      return application
    end
    
    def initialize(cgi, mode)
      @cgi = cgi
      @mode = mode
      @bts = BTS.new(Config[:project_dir])
      @actions, @default_action = load_actions(Config[:action_dir])
      @project = nil
      
      @lang = @cgi.get_param('lang', Config[:language])
      MessageBundle.open(Config[:resource_dir], @lang, Config[:message_bundle_name])
      
      # initialize TLS
      Thread.current[:element_renderer] = {}
      
      # Store application object to TLS.
      Thread.current[:CGIApplication] = self
      CGIApplication.instance()
    end
    attr_reader :cgi, :mode, :bts
    
    def action()
      name = @cgi.get_param('action', '')
      action_class = name.empty? ? @default_action : @actions[name]
      if action_class then
        action = action_class.new(@cgi, @bts, @mode, @lang)
        project = action.project
        
        type = action.cache_type
        key = @mode.url + ':' + action.cache_key
        
        if project && Config[:use_html_cache] then
          result = project.load_cache(type, key)
        end
        result = action.execute() unless result
        
        if project then
          if Config[:use_html_cache] then
            project.save_cache(type, key, result)
          else
            project.invalidate_cache(type, key)
          end
        end
        
        result
      else
        raise ParameterError, "No such action : #{name}"
      end
    end
    
    private
    def load_actions(dir)
      # load actions
      Dir.glob(dir + "/*\.rb").each do |action_script|
        require action_script.untaint
      end
      
      # init action map
      actions = Hash.new
      default = nil
      ObjectSpace.each_object(Class) do |class_obj|
        ancestors = class_obj.ancestors
        ancestors.delete(class_obj)
        if ancestors.include?(Kagemai::Action) then
          actions[class_obj.name] = class_obj
          default = class_obj if class_obj.default?
        end
      end
        
      raise InitializeError, 'No default action loaded.' unless default
      [actions, default]
    end
  end
end
