package org.junitdoc.ui;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.junitdoc.JUnitDocPlugin;

public abstract class Exporter {

	private Shell shell;

	private String title;

	public Exporter(Shell shell, String title) {
		this.shell = shell;
		this.title = title;
	}

	protected abstract String getContents() throws Exception;

	protected abstract String getFileName();

	protected abstract String[] getFilterExtensions();

	public void export() {

		FileDialog dialog = new FileDialog(shell, SWT.SAVE);
		dialog.setText("Export " + title);
		dialog.setFileName(getFileName());
		dialog.setFilterExtensions(getFilterExtensions());
		dialog.setFilterPath(new File(".").getAbsolutePath());
		final String fileName = dialog.open();
		if (fileName != null) {

			ProgressMonitorDialog monitorDialog = new ProgressMonitorDialog(
					JUnitDocPlugin.getDefault().getWorkbench().getDisplay()
							.getActiveShell());

			try {
				monitorDialog.run(true, false, new IRunnableWithProgress() {
					public void run(IProgressMonitor monitor)
							throws InvocationTargetException,
							InterruptedException {
						monitor.beginTask("Exporting DecisionTable.", 2);
						try {
							String contents = getContents();

							monitor.worked(1);

							save(fileName, contents);

							monitor.worked(2);

							monitor.done();

						} catch (Throwable e) {
							throw new InvocationTargetException(e);
						}
					}
				});
			} catch (InvocationTargetException e) {
				JUnitDocPlugin.errorLog("can't save a file. path=" + fileName,
						e);
			} catch (InterruptedException e) {
				MessageDialog.openInformation(shell, "Export DecisionTable",
						"Canceld Export DecisionTable.");
			}

		}
	}

	private void save(String fileName, String contents) throws IOException {
		PrintWriter pw = null;
		try {
			pw = new PrintWriter(new BufferedWriter(new FileWriter(fileName)));

			pw.print(contents);
			pw.close();

		} finally {
			if (pw != null) {
				pw.close();
			}
		}
	}

}
