package org.junitdoc.core.util;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TextElement;

public class JavaDocUtils {

	public static TextElement findSingleJavadocValue(Javadoc javaDoc, String tag) {

		List<TagElement> tags = javaDoc.tags();

		for (TagElement tagElement : tags) {
			if (tagElement.getTagName().equals(tag)) {

				List<TextElement> fragments = tagElement.fragments();

				if (fragments != null && fragments.size() == 1) {
					return fragments.get(0);
				}
			}
		}
		return null;
	}

	public static List<TextElement> findMultiJavadocValue(Javadoc javaDoc,
			String tag) {

		List<TextElement> list = new ArrayList<TextElement>();

		List<TagElement> tags = javaDoc.tags();

		for (TagElement tagElement : tags) {
			if (tagElement.getTagName().equals(tag)) {

				List<TextElement> fragments = tagElement.fragments();

				if (fragments != null && fragments.size() == 1) {
					list.add(fragments.get(0));
				}
			}
		}
		return list;
	}
}
