package org.junitdoc.core.rewriter;

import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;

public abstract class NewDecisionTableBodyHandler extends RewriteHandlerAdapter {

	private String decisionTableName;
	private String newBodyDeclarationName;

	public NewDecisionTableBodyHandler(String decisionTableName,
			String newBodyDeclarationName) {
		this.decisionTableName = decisionTableName;
		this.newBodyDeclarationName = newBodyDeclarationName;
	}

	public abstract String getBodyAnnotation();

	public void rewrite(ASTNode node, ASTRewrite rewrite) {

		// first, find declaration of decision table.
		AnnotationTypeDeclaration type = ASTUtils
				.findAnnotationTypeDeclaration(node, decisionTableName);

		// Second, find declaration of bodyAnnotation in decision table.
		AnnotationTypeDeclaration annoTypeDclaration = ASTUtils
				.findAnnotationTypeDeclaration(type, getBodyAnnotation());

		AST ast = node.getAST();

		// declare new annotation
		ListRewrite listRewrite = rewrite.getListRewrite(annoTypeDclaration,
				AnnotationTypeDeclaration.BODY_DECLARATIONS_PROPERTY);

		AnnotationTypeDeclaration newAnnoTypeDeclaration = ast
				.newAnnotationTypeDeclaration();
		newAnnoTypeDeclaration.setName(ast.newSimpleName(newBodyDeclarationName));

		listRewrite.insertLast(newAnnoTypeDeclaration, null);
	}

}
