package org.seasar.struts.extension.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

import org.seasar.framework.util.Base64Util;
import org.seasar.framework.util.SerializeUtil;

/**
 * オブジェクトをシリアライズするためのユーティリティです。
 *
 * @author awaawa
 *
 */
public class SerializeUtilz {

	/**
	 * 対象オブジェクトをシリアライズ、圧縮、Base64エンコードします。
	 * @param obj 対象オブジェクト
	 * @return 対象オブジェクトをシリアライズ、圧縮、Base64エンコードした文字列
	 */
	public static String fromObjectToString(Object obj) {

		if (obj == null || !(obj instanceof Serializable)) {
			return null;
		}

		ByteArrayOutputStream outputStream = null;
		GZIPOutputStream gzipOutputStream = null;
		byte[] bytes = SerializeUtil.fromObjectToBinary(obj);

		try {
			outputStream = new ByteArrayOutputStream();
			gzipOutputStream = new GZIPOutputStream(outputStream);
			gzipOutputStream.write(bytes);
			gzipOutputStream.finish();
			// TODO ダメ文字の変換処理を行うこと。
			String value = Base64Util.encode(outputStream.toByteArray());
			return value;
		} catch (IOException e) {
			throw new RuntimeException(e);
		} finally {
			if (gzipOutputStream != null) {
				try {
					gzipOutputStream.close();
				} catch (IOException e) {
				}
			}

			if (outputStream != null) {
				try {
					outputStream.close();
				} catch (IOException e) {
				}
			}
		}
	}

	/**
	 * シリアライズ、圧縮、Base64エンコードした文字列をオブジェクトに戻します。
	 * @param str オブジェクトをシリアライズ、圧縮、Base64エンコードした文字列
	 * @return オブジェクト
	 */
	public static Object fromStringToObject(String str) {

		if (str == null || str.equals("")) {
			return null;
		}

		byte[] bytes = Base64Util.decode(str);

		ByteArrayInputStream in = null;
		GZIPInputStream gzipIn = null;
		BufferedInputStream bufferedIn = null;
		ByteArrayOutputStream byteArrayOut = null;

		try {
			in = new ByteArrayInputStream(bytes);
			gzipIn = new GZIPInputStream(in);
			bufferedIn = new BufferedInputStream(gzipIn);

			byteArrayOut = new ByteArrayOutputStream();

			while (true) {
				int iRead = bufferedIn.read();
				if (iRead < 0) {
					break;
				}

				byteArrayOut.write(iRead);
			}
			byteArrayOut.flush();

			return SerializeUtil.fromBinaryToObject(byteArrayOut.toByteArray());

		} catch (IOException e) {
			throw new RuntimeException(e);
		} finally {
			if (byteArrayOut != null) {
				try {
					byteArrayOut.close();
				} catch (IOException e) {
				}
			}

			for (InputStream i : new InputStream[]{
									bufferedIn, gzipIn, in}) {
				if (i != null) {
					try {
						i.close();
					} catch (IOException e) {
					}
				}
			}
		}
	}
}
