package org.seasar.struts.extension.taglib;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;

import org.apache.struts.taglib.TagUtils;
import org.seasar.framework.container.SingletonS2Container;
import org.seasar.framework.convention.NamingConvention;
import org.seasar.framework.util.StringUtil;
import org.seasar.struts.extension.util.SerializeUtilz;
import org.seasar.struts.taglib.S2FormTag;
import org.seasar.struts.util.S2ActionMappingUtil;

/**
 * {@link S2FormTag} の拡張クラスです。
 *
 * @author awaawa
 *
 */
public class XFormTag extends S2FormTag {

	/** serialVersionUID。 */
	private static final long serialVersionUID = 1L;

	/** フラグメント。 */
	private String fragment;

	/**
	 * {@inheritDoc}
	 * {@link NamingConvention#getViewRootPath()} を付与します。
	 * 差分変更ができないため、
	 * {@link S2FormTag#renderAction(StringBuffer)}
	 * の処理をコピーして、一部分を修正しています。sastrutsのバージョンアップ時に注意が必要になります。
	 */
	@Override
	protected void renderAction(StringBuffer results) {
		HttpServletRequest request = (HttpServletRequest) this.pageContext.getRequest();
		HttpServletResponse response = (HttpServletResponse) this.pageContext.getResponse();
		results.append(" action=\"");
		String contextPath = request.getContextPath();
		StringBuffer value = new StringBuffer();
		if (StringUtil.isNotEmpty(contextPath)) {
			value.append(contextPath);
		}

		NamingConvention namingConvention = SingletonS2Container.getComponent(NamingConvention.class);
		String viewRootPath = namingConvention.getViewRootPath();
		if (StringUtil.isNotEmpty(viewRootPath)) {
			value.append(viewRootPath);
		}

		value.append(this.action);
		results.append(response.encodeURL(value.toString()));

		if (StringUtil.isNotEmpty(this.getFragment())) {
			results.append(this.getFragment());
		}

		results.append("\"");
	}

	/**
	 * {@inheritDoc}
	 * actionForm がシリアライズ可能な場合、
	 * リクエストパラメータにBase64エンコードされた ActionForm の直列化情報を
	 * inputタグ(hidden)に設定します。
	 */
	@Override
	public int doEndTag() throws JspException {

		StringBuffer results = new StringBuffer();
		results.append(this.renderCustomHidden());
		TagUtils.getInstance().write(this.pageContext, results.toString());

		return super.doEndTag();
	}

	/**
	 * カスタムhidden項目を提供します。
	 * @return カスタムhidden項目
	 */
	protected String renderCustomHidden() {

		StringBuffer results = new StringBuffer();

		Object form = S2ActionMappingUtil.getActionMapping().getActionForm();

		String value = SerializeUtilz.fromObjectToString(form);

		if (value != null) {
			String name = S2ActionMappingUtil.getActionMapping().getAttribute();
			results.append(this.createHidden(name, value));
		}

		return results.toString();
	}

	/**
	 * hidden項目を作成します。
	 * @param name 項目名
	 * @param value 項目値
	 * @return hidden項目
	 */
	protected String createHidden(String name, String value) {

		TagUtils tagUtils = TagUtils.getInstance();

		StringBuffer sb = new StringBuffer();
		sb.append("<input type=\"hidden\" name=\"");
		sb.append(tagUtils.filter(name));
		sb.append("\" value=\"");
		sb.append(tagUtils.filter(value));

		if (TagUtils.getInstance().isXhtml(this.pageContext)) {
			sb.append("\" />");
		} else {
			sb.append("\">");
		}
		return sb.toString();
	}

	/**
	 * フラグメントを設定します。
	 * @param fragment フラグメント
	 */
	public void setFragment(String fragment) {
		this.fragment = fragment;
	}

	/**
	 * フラグメントを返します。
	 * @return フラグメント
	 */
	public String getFragment() {
		return this.fragment;
	}
}
