package org.seasar.struts.extension.filter;

import java.io.IOException;

import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.seasar.framework.container.S2Container;
import org.seasar.framework.container.SingletonS2Container;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;
import org.seasar.framework.convention.NamingConvention;
import org.seasar.framework.util.StringUtil;
import org.seasar.struts.config.S2ExecuteConfig;
import org.seasar.struts.filter.RoutingFilter;
import org.seasar.struts.util.RequestUtil;
import org.seasar.struts.util.RoutingUtil;
import org.seasar.struts.util.S2ExecuteConfigUtil;

/**
 * {@link RoutingFilter} の拡張クラスです。
 *
 * @author awaawa
 *
 */
public class XRoutingFilter extends RoutingFilter {

	/**
	 * {@inheritDoc}
	 * {@link NamingConvention#getViewRootPath()}　を調整して処理します。
	 * 差分変更ができないため、
	 * {@link RoutingFilter#doFilter(ServletRequest, ServletResponse, FilterChain)}}
	 * の処理をコピーして、一部分を修正しています。sastrutsのバージョンアップ時に注意が必要になります。
	 */
	@Override
	public void doFilter(ServletRequest request, ServletResponse response,
			FilterChain chain) throws IOException, ServletException {
		HttpServletRequest req = (HttpServletRequest) request;
		HttpServletResponse res = (HttpServletResponse) response;
		String contextPath = req.getContextPath();
		if (contextPath.equals("/")) {
			contextPath = "";
		}
		String path = RequestUtil.getPath(req);

// add start
		NamingConvention namingConvention
				= SingletonS2Container.getComponent(NamingConvention.class);
		String viewRootPath = namingConvention.getViewRootPath();

		String orgPath = path;
		if (viewRootPath != null && !viewRootPath.equals("")) {
			if (path.endsWith(".jsp")) {
				path = viewRootPath + path;
			} else {
				if (path.startsWith(viewRootPath)) {
					path = path.substring(viewRootPath.length());
				} else {
					chain.doFilter(request, response);
					return;
				}
			}
		}
// add end

		if (!processDirectAccess(request, response, chain, path)) {
			return;
		}

// change start
// 「res.sendRedirect(・・・ + path + ・・・)
// ↓
// res.sendRedirect(・・・ + originalPath + ・・・)」
		if (path.indexOf('.') < 0) {
			String[] names = StringUtil.split(path, "/");
			S2Container container = SingletonS2ContainerFactory.getContainer();
			StringBuilder sb = new StringBuilder(50);
			for (int i = 0; i < names.length; i++) {
				if (container.hasComponentDef(sb + names[i] + "Action")) {
					String actionPath = RoutingUtil.getActionPath(names, i);
					String paramPath = RoutingUtil.getParamPath(names, i + 1);
					if (StringUtil.isEmpty(paramPath)) {
						if (!path.endsWith("/")) {
							String queryString = "";
							if (req.getQueryString() != null) {
								queryString = "?" + req.getQueryString();
							}
							res.sendRedirect(contextPath + orgPath + "/"
									+ queryString);
							return;
						} else if (S2ExecuteConfigUtil.findExecuteConfig(
								actionPath, req) != null) {
							forward((HttpServletRequest) request,
									(HttpServletResponse) response, actionPath,
									null, null);
							return;
						}
					} else {
						S2ExecuteConfig executeConfig = S2ExecuteConfigUtil
								.findExecuteConfig(actionPath, paramPath);
						if (executeConfig != null) {
							forward((HttpServletRequest) request,
									(HttpServletResponse) response, actionPath,
									paramPath, executeConfig);
							return;
						}
					}
				}
				if (container.hasComponentDef(sb + "indexAction")) {
					String actionPath = RoutingUtil.getActionPath(names, i - 1)
							+ "/index";
					String paramPath = RoutingUtil.getParamPath(names, i);
					if (StringUtil.isEmpty(paramPath)) {
						if (!path.endsWith("/")) {
							String queryString = "";
							if (req.getQueryString() != null) {
								queryString = "?" + req.getQueryString();
							}
							res.sendRedirect(contextPath + orgPath + "/"
									+ queryString);
							return;
						} else if (S2ExecuteConfigUtil.findExecuteConfig(
								actionPath, req) != null) {
							forward((HttpServletRequest) request,
									(HttpServletResponse) response, actionPath,
									null, null);
							return;
						}
					} else {
						S2ExecuteConfig executeConfig = S2ExecuteConfigUtil
								.findExecuteConfig(actionPath, paramPath);
						if (executeConfig != null) {
							forward((HttpServletRequest) request,
									(HttpServletResponse) response, actionPath,
									paramPath, executeConfig);
							return;
						}
					}
				}
				sb.append(names[i] + "_");
			}
			if (container.hasComponentDef(sb + "indexAction")) {
				String actionPath = RoutingUtil.getActionPath(names,
						names.length - 1)
						+ "/index";
				if (!path.endsWith("/")) {
					String queryString = "";
					if (req.getQueryString() != null) {
						queryString = "?" + req.getQueryString();
					}
					res.sendRedirect(contextPath + orgPath + "/" + queryString);
					return;
				} else if (S2ExecuteConfigUtil.findExecuteConfig(actionPath,
						req) != null) {
					forward((HttpServletRequest) request,
							(HttpServletResponse) response, actionPath, null,
							null);
					return;
				}
			}
		}
// change end
		chain.doFilter(request, response);
	}
}
