package org.seasar.struts.extension.customizer;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.validator.Arg;
import org.apache.commons.validator.Field;
import org.apache.commons.validator.Form;
import org.apache.commons.validator.Var;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.util.ClassUtil;
import org.seasar.struts.config.S2ActionMapping;
import org.seasar.struts.customizer.ActionCustomizer;
import org.seasar.struts.extension.config.XActionMapping;
import org.seasar.struts.validator.S2ValidatorResources;

/**
 * {@link ActionCustomizer} の拡張クラスです。
 *
 * @author awaawa
 *
 */
public class XActionCustomizer extends ActionCustomizer {

	/** インデックスの引数位置。 */
	private static final int INDEX_ARG_POSITION = 5;

	/** マーク[インデックス]。 */
	private static final String MARK_INDEX = "[].";

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected S2ActionMapping createActionMapping() {
		return new XActionMapping();
	}

	/**
	 * {@inheritDoc}
	 * ActionFormのプロパティが配列やリストの場合でも。正しく validate の設定をします。
	 */
	@Override
	protected void setupValidator(S2ActionMapping actionMapping, S2ValidatorResources validatorResources) {

		Map<String, Form> forms = new HashMap<String, Form>();
		for (String methodName : actionMapping.getExecuteMethodNames()) {
			if (actionMapping.getExecuteConfig(methodName).isValidator()) {
				Form form = new Form();
				form.setName(actionMapping.getName() + "_" + methodName);
				forms.put(methodName, form);
			}
		}

		for (Class<?> clazz = actionMapping.getActionFormBeanDesc().getBeanClass();
				clazz != null && clazz != Object.class;
				clazz = clazz.getSuperclass()) {

			for (java.lang.reflect.Field field : ClassUtil.getDeclaredFields(clazz)) {

				for (Annotation anno : field.getDeclaredAnnotations()) {
					this.processAnnotation(field.getName(), anno, validatorResources, forms);
				}

				Class<?> c = field.getType();
				if (c != String.class && c != Boolean.class) {

					for (java.lang.reflect.Field f : c.getFields()) {
						for (Annotation anno : f.getDeclaredAnnotations()) {
							this.processAnnotation(
									field.getName() + "." + f.getName(),
									anno,
									validatorResources,
									forms);
						}
					}

					Class<?> actualClazz = null;
					if (List.class.isAssignableFrom(c)) {
						ParameterizedType paramType	= (ParameterizedType) field.getGenericType();
						actualClazz = (Class<?>) paramType.getActualTypeArguments()[0];
					}

					if (c.isArray()) {
						actualClazz = c.getComponentType();
					}

					if (actualClazz != null
							&& actualClazz != String.class
							&& actualClazz != Boolean.class) {

						for (java.lang.reflect.Field f : actualClazz.getFields()) {
							for (Annotation anno : f.getDeclaredAnnotations()) {
								this.processAnnotation(
										field.getName() + MARK_INDEX + f.getName(),
										anno,
										validatorResources,
										forms);
							}
						}
					}
				}
			}
		}

		for (Form form : forms.values()) {
			validatorResources.addForm(form);
		}

		// TODO パフォーマンス的に 以下の2つの for 文のどちらを先にしたほうがいいか考えること。
		// とりあえず、現状は配列 or java.util.List のみ。
		BeanDesc beanDesc = actionMapping.getActionFormBeanDesc();
		for (String methodName : actionMapping.getExecuteMethodNames()) {
			if (!actionMapping.getExecuteConfig(methodName).isValidator()) {
				continue;
			}

			String formKey = actionMapping.getName() + "_" + methodName;
			Form form = validatorResources.getForm(null, formKey);

			@SuppressWarnings("unchecked")
			List<Field> list = form.getFields();

			for (Field field : list) {
				String property = field.getProperty();
				if (property != null && field.getIndexedListProperty() != null) {
					continue;
				}

				if (property == null) {
					property = field.getIndexedListProperty();
				}

				if (property == null || property.contains(".")) {
					continue;
				}

				Class<?> type = beanDesc.getPropertyDesc(property).getPropertyType();

				for (String suffix : new String[]{"s", "List"}) {
					String combiProperty;
					if ((type.isArray() || List.class.isAssignableFrom(type))
							&& property.endsWith(suffix)) {
						int endIndex = property.length() - suffix.length();
						combiProperty = property.substring(0, endIndex);
					} else {
						combiProperty = property + suffix;
					}

					if (combiProperty != null && form.getField(combiProperty) != null) {
						field.addVar("startIndex", "1", Var.JSTYPE_INT);
						break;
					}
				}

				if (type.isArray() || List.class.isAssignableFrom(type)) {

					if (!"required".equals(field.getDepends())) {
						field.setIndexedListProperty(property);
						field.setProperty(null);
						field.generateKey();

						String trimStr = ".null";
						String key = field.getKey();
						if (key != null && key.endsWith(trimStr)) {
							int endIndex = key.length() - trimStr.length();
							field.setKey(key.substring(0, endIndex));
						}
					}
				}
			}
		}
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	protected Field createField(
			String propertyName,
			String validatorName,
			Map<String, Object> props,
			S2ValidatorResources validatorResources) {

		Field field = super.createField(propertyName, validatorName, props, validatorResources);

		Arg[] args = field.getArgs(field.getDepends());
		int position = INDEX_ARG_POSITION;
		if (args != null && args.length > position) {
			position = args.length;
		}

		Arg arg = new Arg();
		arg.setKey("errors.index");
		arg.setResource(true);
		arg.setPosition(position);
		field.addArg(arg);

		if (!propertyName.contains(MARK_INDEX)) {
			return field;
		}

		field.setIndexedListProperty(propertyName.substring(0, propertyName.indexOf(MARK_INDEX)));
		field.setProperty(propertyName.substring(propertyName.indexOf(MARK_INDEX) + 3, propertyName.length()));
		field.generateKey();

		return field;
	}
}
