package org.seasar.struts.extension.config;

import org.apache.struts.action.ActionForward;
import org.seasar.framework.container.SingletonS2Container;
import org.seasar.framework.convention.NamingConvention;
import org.seasar.struts.config.S2ActionMapping;
import org.seasar.struts.util.ServletContextUtil;

/**
 * {@link S2ActionMapping} の拡張クラスです。
 *
 * @author awaawa
 *
 */
public class XActionMapping extends S2ActionMapping {

	/** serialVersionUID。 */
	private static final long serialVersionUID = 1L;

	/** リダイレクトマーク。 */
	private static final String REDIRECT = "redirect=true";

	/**
	 * {@inheritDoc}
	 * 内部ダイレクトの場合、{@link NamingConvention#getViewRootPath()} を付与します。
	 * 差分変更ができないため、
	 * {@link S2ActionMapping#createForward(String, boolean)}
	 * の処理をコピーして、一部を修正しています。sastruts のバージョンアップ時に注意が必要になります。
	 */
	@Override
	public ActionForward createForward(String path, boolean redirect) {
		if (path == null) {
			return null;
		}
		if (path.endsWith(REDIRECT)) {
			redirect = true;
			path = path.substring(0, path.length() - REDIRECT.length() - 1);
		}
		if (path.indexOf(":") < 0) {
			if (!path.startsWith("/")) {
				path = this.getActionPath(this.componentDef.getComponentName()) + path;
			}

			if (redirect && !this.isJspPath(path)) {
				NamingConvention namingConvention
						= SingletonS2Container.getComponent(
								NamingConvention.class);
				if (!path.startsWith(
						namingConvention.getViewRootPath() + "/")) {
					path = namingConvention.getViewRootPath() + path;
				}
			}

			if (!redirect) {
				if (!this.isJspPath(path)) {
					path = this.createRoutingPath(path);
				} else {
					String viewPrefix = ServletContextUtil.getViewPrefix();
					if (viewPrefix != null) {
						path = viewPrefix + path;
					}
				}
			}
		}
		return new ActionForward(path, redirect);
	}

	/**
	 * JSPパスかを判定します。
	 * @param path 対象パス
	 * @return JSPパスの場合、{@code true}
	 */
	protected boolean isJspPath(String path) {
		int paramPos = path.indexOf('?');
		if (paramPos < 0) {
			paramPos = path.length();
		}
		return 0 < path.lastIndexOf('.', paramPos);
	}
}
