package org.seasar.struts.extension.action;

import java.io.IOException;
import java.util.Map;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.config.ForwardConfig;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.upload.MultipartRequestHandler;
import org.seasar.framework.beans.BeanDesc;
import org.seasar.framework.beans.IllegalPropertyRuntimeException;
import org.seasar.framework.beans.PropertyDesc;
import org.seasar.framework.beans.factory.BeanDescFactory;
import org.seasar.framework.container.factory.SingletonS2ContainerFactory;
import org.seasar.framework.util.StringUtil;
import org.seasar.struts.action.S2RequestProcessor;
import org.seasar.struts.config.S2ActionMapping;
import org.seasar.struts.config.S2ExecuteConfig;
import org.seasar.struts.extension.annotation.ReadOnly;
import org.seasar.struts.extension.annotation.SessionScope;
import org.seasar.struts.extension.util.SerializeUtilz;
import org.seasar.struts.util.S2ActionMappingUtil;
import org.seasar.struts.util.S2ExecuteConfigUtil;

/**
 * {@link S2RequestProcessor} の拡張クラスです。
 *
 * @author awaawa
 *
 */
public class XRequestProcessor extends S2RequestProcessor {

	/** ログ。 */
	private static final Log LOG = LogFactory.getLog(XRequestProcessor.class);

	/** 初期パラメータ、リクエスト属性[actionForm 継続]。 */
	private static final String ACTION_FORM_PROCEED = "org.apache.struts.extension.form.proceed";

	/** リクエスト属性[actionForm 初期化マーク]。 */
	private static final String ACTION_FORM_INIT = "org.seasar.struts.extension.form.init";

	/** actionForm 継続。 */
	private boolean formProceed;

	/**
	 * {@inheritDoc}
	 * {@link SessionScope} が設定されているフィールドに session 上の値を設定します。
	 */
	@Override
	public void init(ActionServlet servlet, ModuleConfig moduleConfig)
			throws ServletException {

		super.init(servlet, moduleConfig);

		String proceedStr = servlet.getServletContext().getInitParameter(ACTION_FORM_PROCEED);

		this.formProceed = Boolean.parseBoolean(proceedStr);
	}

	/**
	 * {@inheritDoc}
	 * {@link SessionScope} が設定されているフィールドに session 上の値を設定します。
	 */
	@Override
	protected Action processActionCreate(
			HttpServletRequest request,
			HttpServletResponse response,
			ActionMapping mapping) throws IOException {

		this.importSessionToProperties(request, (S2ActionMapping) mapping);

		return super.processActionCreate(request, response, mapping);
	}

	/**
	 * {@link SessionScope} が設定されているフィールドに session 上の値を設定します。
	 * @param request リクエスト
	 * @param actionMapping アクションマッピング
	 */
	protected void importSessionToProperties(
			HttpServletRequest request,
			S2ActionMapping actionMapping) {

		Object action = actionMapping.getAction();
		BeanDesc actionBeanDesc = actionMapping.getActionBeanDesc();
		for (int i = 0; i < actionBeanDesc.getPropertyDescSize(); i++) {
			PropertyDesc pd = actionBeanDesc.getPropertyDesc(i);

			if (pd.isWritable()
					&& this.isExportableProperty(pd)
					&& pd.getField() != null
					&& pd.getField().getAnnotation(SessionScope.class) != null) {

				HttpSession session = request.getSession();
				Object obj = session.getAttribute(pd.getPropertyName());
				Class<?> propertyType = pd.getPropertyType();

				if (obj != null && propertyType.isAssignableFrom(obj.getClass())) {
					pd.setValue(action, obj);
				}
			}
		}
	}

	/**
	 * {@inheritDoc}
	 * {@link SessionScope} が設定されているフィールドを session に保存します。
	 */
	@Override
	protected void processForwardConfig(
			HttpServletRequest request,
			HttpServletResponse response,
			ForwardConfig forward) throws IOException, ServletException {

		this.exportPropertiesToSession(
				request,
				S2ActionMappingUtil.getActionMapping(),
				S2ExecuteConfigUtil.getExecuteConfig());

		super.processForwardConfig(request, response, forward);
	}

	/**
	 * {@link SessionScope} が設定されている プロパティをセッションに設定します。
	 * @param request リクエスト
	 * @param actionMapping アクションマッピング
	 * @param executeConfig 実行設定
	 */
	protected void exportPropertiesToSession(
			HttpServletRequest request,
			S2ActionMapping actionMapping,
			S2ExecuteConfig executeConfig) {

		Object action = actionMapping.getAction();
		BeanDesc actionBeanDesc = actionMapping.getActionBeanDesc();
		for (int i = 0; i < actionBeanDesc.getPropertyDescSize(); i++) {
			PropertyDesc pd = actionBeanDesc.getPropertyDesc(i);
			if (pd.isReadable()
					&& this.isExportableProperty(pd)
					&& pd.getField() != null
					&& pd.getField().getAnnotation(SessionScope.class) != null) {

				Object value = pd.getValue(action);

				HttpSession session = request.getSession();
				if (value != null) {
					session.setAttribute(pd.getPropertyName(), value);
				} else {
					session.removeAttribute(pd.getPropertyName());
				}
			}
		}
	}

	/**
	 * {@inheritDoc}
	 * リクエストパラメータに Base64 エンコードされた ActionForm の直列化情報がある場合、その情報を設定します。
	 */
	@Override
	protected void processPopulate(
			HttpServletRequest request,
			HttpServletResponse response,
			ActionForm form,
			ActionMapping mapping) throws ServletException {

		if (form == null) {
			return;
		}
		form.setServlet(this.servlet);
		String contentType = request.getContentType();
		String method = request.getMethod();
		form.setMultipartRequestHandler(null);
		MultipartRequestHandler multipartHandler = null;
		if (contentType != null
				&& contentType.startsWith("multipart/form-data")
				&& method.equalsIgnoreCase("POST")) {
			multipartHandler = this.getMultipartHandler(mapping.getMultipartClass());
			if (multipartHandler != null) {
				multipartHandler.setServlet(this.servlet);
				multipartHandler.setMapping(mapping);
				multipartHandler.handleRequest(request);
				Boolean maxLengthExceeded = (Boolean) request
						.getAttribute(MultipartRequestHandler.ATTRIBUTE_MAX_LENGTH_EXCEEDED);
				if (maxLengthExceeded != null
						&& maxLengthExceeded.booleanValue()) {
					form.setMultipartRequestHandler(multipartHandler);
					this.processExecuteConfig(request, response, mapping);
					return;
				}
				SingletonS2ContainerFactory.getContainer().getExternalContext().setRequest(request);
			}
		}
		this.processExecuteConfig(request, response, mapping);
		form.reset(mapping, request);
		Map<String, Object> params = this.getAllParameters(request, multipartHandler);
		S2ActionMapping actionMapping = (S2ActionMapping) mapping;

// add start
		Object bean = actionMapping.getActionForm();
		Object action = actionMapping.getAction();

		// actionForm がなければ、処理をスキップ。
		if (bean == null || bean.equals(action)) {
			return;
		}

		// パラメータにある ActionForm の直列化情報を設定(リクエスト毎に一度だけ)。
		if (!Boolean.TRUE.equals(request.getAttribute(ACTION_FORM_INIT))) {

			request.setAttribute(ACTION_FORM_INIT, Boolean.TRUE);

			String name = actionMapping.getAttribute();
			String str = request.getParameter(name);

			Object actionForm = actionMapping.getActionForm();
			this.convertActionForm(actionForm, str);
		}

		// actionForm 継続 かつ 一度リクエストパラメータを設定済みの場合、処理をスキップ。
		if (this.formProceed) {
			String key = ACTION_FORM_PROCEED + "." + bean.getClass().getName();

			if (Boolean.TRUE.equals(request.getAttribute(key))) {
				return;
			}

			request.setAttribute(key, Boolean.TRUE);
		}
// add end

		for (String name : params.keySet()) {
			try {
				this.setProperty(actionMapping.getActionForm(), name, params.get(name));
			} catch (Throwable t) {
				throw new IllegalPropertyRuntimeException(actionMapping.getActionFormBeanDesc().getBeanClass(), name, t);
			}
		}
	}

	/**
	 * {@inheritDoc}
	 * {@link ReadOnly} が設定されているフィールドは設定しません。
	 */
	@Override
	protected void setProperty(Object bean, String name, Object value) {

		if (bean == null) {
			return;
		}

		BeanDesc beanDesc = BeanDescFactory.getBeanDesc(bean.getClass());
		if (beanDesc.hasField(name)
				&& beanDesc.getField(name).getAnnotation(ReadOnly.class) != null) {
			return;
		}

		super.setProperty(bean, name, value);
	}

	/**
	 * アクションフォームにActionForm のシリアライズ情報文字列を設定します。
	 * @param actionForm アクションフォーム
	 * @param value 直列化情報
	 */
	protected void convertActionForm(Object actionForm, String value) {

		if (actionForm == null || StringUtil.isEmpty(value)) {
			return;
		}

		Object obj = null;
		try {
			obj = SerializeUtilz.fromStringToObject(value);
		} catch (RuntimeException e) {
			LOG.warn("ActionForm のデシリアイズに失敗。", e);
		}

		if (obj == null) {
			return;
		}

		BeanDesc objBeanDesc = BeanDescFactory.getBeanDesc(obj.getClass());
		BeanDesc actionFormBeanDesc
				= BeanDescFactory.getBeanDesc(actionForm.getClass());
		for (int i = 0; i < objBeanDesc.getPropertyDescSize(); i++) {
			PropertyDesc objPropertyDesc = objBeanDesc.getPropertyDesc(i);
			PropertyDesc actionFormPropertyDesc = actionFormBeanDesc.getPropertyDesc(objPropertyDesc.getPropertyName());

			if (objPropertyDesc.isReadable() && actionFormPropertyDesc.isWritable()) {
				actionFormPropertyDesc.setValue(actionForm, objPropertyDesc.getValue(obj));
			}
		}
	}
}
