package org.apache.commons.validator;

import java.util.Map;

import org.apache.struts.util.MessageResources;
import org.seasar.framework.util.IntegerConversionUtil;
import org.seasar.struts.util.MessageResourcesUtil;

/**
 * {@link ValidatorAction} の拡張クラスです。
 * <pre>
 * このクラスを利用する場合は、commons-validator-X.X.X.jarの
 * org.apache.commons.validator.digester-rules.xml をコピーし、
 * ソースフォルダ配下に同じディレクトリ構成で配置してください。
 * その際、「digester-rules.xml」の以下の箇所を変更してください。
 * {@link org.apache.commons.validator.ValidatorAction}
 * ↓
 * {@link org.apache.commons.validator.XValidatorAction}
 * </pre>
 * @author awaawa
 *
 */
public class XValidatorAction extends ValidatorAction {

	/** serialVersionUID。 */
	private static final long serialVersionUID = 1L;

	/**
	 * {@inheritDoc}
	 * 配列、リストの validate を最後のインデックスまで行います。
	 * また、エラーメッセージが適切に出力されるようにします。
	 */
	@Override
	boolean executeValidationMethod(
			Field field,
			Map params,
			ValidatorResults results,
			int pos) throws ValidatorException {

		Field modifyField = Field.class.cast(field.clone());

		Arg[] args = modifyField.getArgs(modifyField.getDepends());
		for (Arg arg : args) {
			if (arg == null || !"errors.index".equals(arg.getKey())) {
				continue;
			}

			String indexArgStr = " ";
			if (modifyField.isIndexed() || modifyField.getVar("startIndex") != null) {

				int startIndex = 0;
				String startIndexStr = modifyField.getVarValue("startIndex");
				if (startIndexStr != null && !startIndexStr.equals("")) {
					startIndex = IntegerConversionUtil.toPrimitiveInt(startIndexStr);
				}

				if (modifyField.isIndexed()) {
					startIndex++;
				}

				MessageResources messageResources = MessageResourcesUtil.getMessageResources();
				indexArgStr = messageResources.getMessage(arg.getKey(), pos + startIndex);
			}

			arg.setKey(indexArgStr);
			arg.setResource(false);
			break;
		}

		// TODO スレッドセーフか確認すること。
		params.put(Field.class.getName(), modifyField);

		boolean flg = super.executeValidationMethod(modifyField, params, results, pos);

		if (!modifyField.isIndexed()) {
			return flg;
		}

		return true;
	}
}
