<?php
/**
 * 発言を書き込む一連のデータベース処理を提供します。
 * このトランザクションでは次の処理が提供されます。
 *  1. 村オブジェクトの取得(UpdateRoomTransactionから継承されます)
 *  2. ゲーム進行のチェック(UpdateRoomTransactionから継承されます)
 *  3. 発言の追加
 */
class AddTalkTransaction extends UpdateRoomTransaction {
  function _IsLastWords() {
    return !empty($this->last_words);
  }

  function _AddDayTalk($db) {
    if (isset($db->currentUser)) {
      $usr = $db->currentUser;

      if($usr->IsDummyBoy()){
        $type = 'gm_talk';
      }
      elseif($usr->IsLive() && $ROOM->IsDay(false)){
        //生存者で制限時間内
        $type = 'talk';
      }
      if (isset($talk)) {
        return $db->currentRoom->AddTalkAs($usr->player_id, '_', $type, $this->font_type, $this->say);
      }
    }
    return false;
  }

  function _AddNightTalk($db) {
    $room = $db->currentRoom;
    $user = $db->currentUser;
    $update_internal_time = $user->IsWolf(); //時間経過するのは人狼の発言のみ (本人判定)
    //チャンネルとタイプのデフォルト値
    $channel = 'self_'.$user->user_no;
    $type = 'talk';
    if($user->IsWolf(true)) { //人狼
      $channel = $user->IsRole('possessed_mad') ? 'self_talk' : 'wolf'; //犬神判定
      $type = 'howl';
    }
    elseif($user->IsRole('whisper_mad')) { //囁き狂人
      $channel = 'mad';
      $type = 'whisper';
    }
    elseif($user->IsCommon(true)) { //共有者
      $channel = 'common';
      $type = 'whisper';
    }
    elseif($user->IsFox(true)) { //妖狐
      $channel = 'fox';
    }
    $this->_UpdateRoom($db, $room, $update_internal_time);
    $db->currentRoom->AddTalkAs($user->player_id, $channel, $type, $this->font_type, $this->say);
  }

  function _AddHeavenTalk($db) {
    $db->currentRoom->AddTalkAs($user->player_id, 'grave', 'talk', $this->font_type, $this->say);
  }

  function _UpdateLastWords($db) {
    $room = $db->currentRoom;
    $user = $db->currentUser;
    //身代わり君 (仮想 GM 対応) は遺言を専用のシステムメッセージに切り替え
    if ($user->IsDummyBoy()) {
      $room->AddTalkAs($usr->player_id, 'grave', 'gm_talk', $this->font_type, $this->say);
    }
    else {
      $user->last_words = $this->say;
      $user->UpdatePlayerInfo();
    }
  }

  function _run($db) {
    $room = $db->currentRoom;
    $user = $db->currentUser; //Note:オリジナルのコードでは仮想ユーザーを生成していた(2011-05-27 enogu)
    if (!isset($room) || !isset($user)) {
      return false;
    }
    if (isset($this->say) && $this->say != '') {
      if ($this->_IsLastWords()) {
        return $this->_UpdateLastWords($db);
      }
      elseif ($user->IsDead()) {
        return $this->_AddHeavenTalk($db);
      }
      elseif ($room->IsNight()) {
        $this->_UpdateRoom($db, $room, true);
        return $this->_AddNightTalk($db);
      }
      else {
        $this->_UpdateRoom($db, $room, true);
        return $this->_AddDayTalk($db);
      }
    }
  }
}
