<?php
/**
 * 一連の処理をアトミックに実行するための基板を提供します。
 */
abstract class Transaction {
  var $parameters = array();
  /**
   * トランザクション処理の本体を実行します。
   * このメソッドは必ず実装して下さい。
   * @param ChatEngine $db データベース接続を提供するChatEngineオブジェクト
   */
  abstract function __run($db);

  /**
   * データベース接続を指定してトランザクションを実行します。
   * このメソッドはアトミックなデータアクセスを提供します。すべての処理が完了するまでデータベースに加えられた変更は保存されません。
   * トランザクションを完了できなかった場合データベースはロールバックされます。
   * @param ChatEngine $db データベース接続を提供するChatEngineオブジェクト
   * @return mixed|boolean トランザクションの実行結果。失敗した場合はfalseを返します。
   */
  function Run($db) {
    $db->beginTransaction();
    if (($result = $this->__run($db)) !== false) {
      $db->commit();
      return $result;
    }
    else {
      $db->rollBack();
      return false;
    }
  }

  function  __get($name) {
    global $RQ_ARGS;
    if (isset($this->parameters[$name])) {
      return $this->parameters[$name];
    }
    elseif(isset($RQ_ARGS->$name)) {
      return $RQ_ARGS->$name;
    }
    return null;
  }

  function  __set($name, $value) {
    $this->parameters[$name] = $value;
  }
}
?>
