<?php

require_once dirname(__FILE__) . '/../../../../../include/chatengine/chatengine.php';
require_once CHEN_DIR.'/chatroom_class.php';
require_once CHEN_DIR.'/chatuser_class.php';

//現在はinit.phpへの干渉を最小限にしているため、initを先にロードするとroom_classの依存性が解決できない。
require_once dirname(__FILE__) . '/../../../../../include/init.php';
$INIT_CONF->LoadClass('MESSAGE');

require_once dirname(__FILE__) . '/../../../../../include/chatengine/talkconverter.php';

/**
 * Test class for TalkConverter.
 * Generated by PHPUnit on 2011-01-26 at 03:45:49.
 */
class TalkConverterTest extends PHPUnit_Framework_TestCase {

  /**
   * @var TalkConverter
   */
  protected $object;

  /**
   * Sets up the fixture, for example, opens a network connection.
   * This method is called before a test is executed.
   */
  protected function setUp() {
    $this->object = new TalkConverter;
  }

  /**
   * Tears down the fixture, for example, closes a network connection.
   * This method is called after a test is executed.
   */
  protected function tearDown() {

  }

  /**
   * @todo Implement test__get().
   */
  public function test__get() {
    global $MESSAGE;
    $this->assertEquals($MESSAGE->dummy_boy_comment, $this->object->dummy_boy_comment);
    $this->assertNull($this->object->invalid_value);
  }

  private function testConvertResult($exp_class, $exp_player, $exp_volume, $exp_sentence, $actual) {
    list($res_class, $res_player, $res_volume, $res_sentence) = $actual;
    $this->assertEquals($exp_class, $res_class);
    $this->assertEquals($exp_player, $res_player);
    $this->assertEquals($exp_volume, $res_volume);
    $this->assertEquals($exp_sentence, $res_sentence);
  }

  /**
   * @dataProvider dp_testHowl
   */
  public function testHowl($player, $volume, $sentence, $channel, $type, $exp_sentence) {
    $result = $this->object->Howl(null, $player, $volume, $sentence, $channel, $type);
    $this->testConvertResult('wolf-howl', $player, $volume, $exp_sentence, $result);
  }
  public static function dp_testHowl() {
    global $MESSAGE;
    return array(
        array(0, '', 'プレイヤーや音量(フォントサイズ)には依存しない', 'wolf', 'howl', $MESSAGE->wolf_howl),
        array(10, 'small', 'チャンネルやタイプも現時点では勘案されない', 'common', 'talk', $MESSAGE->wolf_howl),
    );
  }

  /**
   * @dataProvider dp_testWhisper
   */
  public function testWhisper($class, $player, $volume, $sentence, $channel, $type, $exp_sentence, $success) {
    $result = $this->object->Whisper(null, $player, $volume, $sentence, $channel, $type);
    if ($success) {
      $this->testConvertResult($class, $player, $volume, $exp_sentence, $result);
    }
    else {
      $this->assertSame(false, $result);
    }
  }
  public static function dp_testWhisper() {
    global $MESSAGE;
    return array(
        array('common-talk', 0, '', '共有チャンネル。実際の役職は判定しない', 'common', 'talk', $MESSAGE->common_talk, true),
        array('common-talk', 10, 'large', '発言タイプは現時点では勘案されない', 'common', 'objection', $MESSAGE->common_talk, true),
        array('lovers-talk', 0, '', '恋人チャンネル。実際の役職は判定しない', 'lovers[4]', 'talk', $MESSAGE->lovers_talk, true),
        array('lovers-talk', 10, 'large', '恋人も発言タイプは現時点では勘案されない', 'lovers[4]', 'objection', $MESSAGE->lovers_talk, true),
        array('lovers-talk', 10, 'large', 'チャンネルが違うと判定不能になる', 'wolf', 'talk', null, false),
    );
  }
}
