<?php
require_once('include/init.php');
Loader::LoadFile('room_manager_class');

if (! DB::ConnectInHeader()) return false;
if (Loader::IsLoaded('index_functions')) RoomManager::Maintenance();

Loader::LoadRequest('RequestRoomManager');
if (RQ::Get()->create_room) {
  //キャッシュの整理
  //村立てのタイミングのみで行うのがもっともインパクトが小さいと考えられるため、この位置で実行することになった。(2013-04-06 enogu)
  Loader::LoadFile('cache_class');
  DocumentCache::Clean();

  Loader::LoadFile('message', 'user_icon_class', 'twitter_class');
  RoomManager::Create();
}
elseif (RQ::Get()->change_room) {
  Loader::LoadFile('session_class', 'user_class');
  RoomManager::Create();
}
elseif (RQ::Get()->describe_room) {
  Loader::LoadFile('chaos_config');
  RoomManager::OutputDescribe();
}
elseif (RQ::Get()->room_no > 0) {
  Loader::LoadFile('session_class', 'user_class', 'option_form_class');
  RoomManager::OutputCreate();
}
else {
  Loader::LoadFile('chaos_config');
  RoomManager::OutputList();
}
