class Pixel extends E {
	imageData: ImageData;

	constructor(width:number, height:number, srcImage?:any, scale?:bool) {
		super();
		this.x = 0;
		this.y = 0;
		this.width = width;
		this.height = height;
		var canvas = window.createCanvas(this.width, this.height);
		var context = canvas.getContext("2d");
		if (srcImage) {
			var image = srcImage;
			if (srcImage instanceof E) {
				var sprite = srcImage.createSprite();
				image = sprite.image;
			}
			if (scale)
				context.drawImage(image, 0, 0, width, height);
			else
				context.drawImage(image, 0, 0);
		}
		this.imageData = context.getImageData(0, 0, this.width, this.height);
		this.disableTransform = true;
	}

	clear(r?:number, g?:number, b?:number, a?:number) {
		if (r === undefined)
			r = 0;
		if (g === undefined)
			g = 0;
		if (b === undefined)
			b = 0;
		if (a === undefined)
			a = 0;
		for (var i=0, len=this.imageData.data.length; i<len; i+=4) {
			this.imageData.data[i] = r;
			this.imageData.data[i+1] = g;
			this.imageData.data[i+2] = b;
			this.imageData.data[i+3] = a;
		}
	}

	draw(context:CanvasRenderingContext2D) {
		context.putImageData(
			this.imageData,
			this.x,
			this.y
		);
	}
}