interface Window {
	mozRequestAnimationFrame(): number;
	webkitRequestAnimationFrame(): number;
	createCanvas(width:number, height:number): HTMLCanvasElement;
	random(min:number, max:number):number;
}

window.requestAnimationFrame =
	window.requestAnimationFrame ||
	window.mozRequestAnimationFrame ||
	window.webkitRequestAnimationFrame ||
	window.msRequestAnimationFrame ||
	(function() {
		var lastTime = Date.now ? Date.now() : new Date().getTime();
		var frame = 1000 / 60;
		return function(func) {
			var currentTime = Date.now ? Date.now() : new Date().getTime();
			var _id = setTimeout(function() {
				func(Date.now ? Date.now() : new Date().getTime());
			}, Math.max(0, lastTime + frame - currentTime));
			lastTime = currentTime;
			return _id;
		};
	}());

window.createCanvas = function(width:number, height:number):HTMLCanvasElement {
	var canvas:HTMLCanvasElement = <HTMLCanvasElement>document.createElement("canvas");
	canvas.width = width;
	canvas.height = height;

	if ("imageSmoothingEnabled" in window) {
		var browser = jg.JGUtil.getBrowser();
		if (browser.opera) {
			canvas.style["imageRendering"] = "-o-crisp-edges";
		} else if (browser.msie) {
			canvas.style["msInterpolationMode"] = "nearest-neighbor";
		} else if (browser.safari) {
			canvas.style["imageRendering"] = "-webkit-optimize-contrast";
		}
		//Note: contextは単一インスタンスなので、ここで指定して呼び出し元で別途contextを取得してもここの設定が有効
		var context = canvas.getContext("2d")
		if(context["imageSmoothingEnabled"])
			context["imageSmoothingEnabled"] = false;
		if(context["webkitImageSmoothingEnabled"])
			context["webkitImageSmoothingEnabled"] = false;
		if(context["mozImageSmoothingEnabled"])
			context["mozImageSmoothingEnabled"] = false;
	}

	return canvas;
}
