module jg {
	export class ResourceLoader {
		resource:Resource;

		constructor(resource:Resource) {
			this.resource = resource;
		}

		load(url:string, identifier:string) {

		}
	}

	export class ImageResourceLoader extends ResourceLoader {
		load(url:string, identifier:string) {
			var image = new Image();
			image.src = this.resource.structure.imageUrl(url);
			var caller = this;
			var callback = this.completed;
			image.onerror = function() {
				callback.call(caller, identifier, image, false);
			};
			image.onload = function() {
				callback.call(caller, identifier, image, true);
			};
		}

		completed(name:string, image:HTMLImageElement, is_success:bool) {
			if (! is_success)
				console.log("error: "+name);
			else
				this.resource.images[name] = image;

			this.resource.requestCompleted(name);
		}
	}

	export class ScriptResourceLoader extends ResourceLoader {
		load(url:string, identifier:string) {
			var script = <HTMLScriptElement>document.createElement("script");
			var heads = document.getElementsByTagName("head");
			if (heads.length == 0)
				throw "can not find head tag";
			script.src = url+"?"+(new Date()).getTime();
			var callback = this.completed;
			script.onload = () => {
				callback.call(this, identifier, script, true);
			}
			script.onerror = () => {
				callback.call(this, identifier, script, false);
			}
			heads[0].appendChild(script);
		}

		completed(name:string, script:HTMLScriptElement, is_success:bool) {
			if (! is_success)
				console.log("error: "+name);
			else
				this.resource.scripts[name] = script;

			this.resource.requestCompleted(name);
		}
	}

	export class SoundResourceLoader extends ResourceLoader {
		load(url:string, identifier:string) {
			var audio = new Audio(null);
			audio.autoplay = false;
			audio.preload = "auto";
			audio.src = this.resource.structure.soundUrl(url);
			audio.load();
			audio.addEventListener("canplaythrough", () => {
				this.completed(identifier, audio, true);
			}, true);
			audio.addEventListener("error", () => {
				this.completed(identifier, audio, false);
			}, true);
		}

		completed(name:string, audio:HTMLAudioElement, is_success:bool) {
			if (! is_success)
				console.log("error: "+name);
			else
				this.resource.sounds[name] = audio;

			this.resource.requestCompleted(name);
		}
	}

	/*
	//webaudio version
	export class SoundResourceLoader extends ResourceLoader {
		load(url:string, identifier:string) {
			var request = new XMLHttpRequest();
			request.open("GET", this.resource.structure.soundUrl(url), true);
			request.responseType = "arraybuffer";

			var callback = this.completed;
			request.onload = () => {
				var context = SimpleSound.getAudioContext();
				if (context) {
					context.decodeAudioData(
						request.response,
						(decodedAudio:AudioBuffer) => {
							callback.call(this, identifier, decodedAudio, true);
						},
						() => {
							callback.call(this, identifier, null, false);
						}
					);
				} else {
					callback.call(this, identifier, null, false);
				}
			}
			request.onerror = () => {
				callback.call(this, identifier, null, false);
			}

			request.send();
		}

		completed(name:string, audio:AudioBuffer, is_success:bool) {
			if (! is_success)
				console.log("error: "+name);
			else
				this.resource.sounds[name] = audio;

			this.resource.requestCompleted(name);
		}
	}
	*/
}