class CharacterFactory {
	charaCol: number;
	animeCnt: number;
	movePixel: number;
	moveTime: number;
	image: HTMLImageElement;
	width: number;
	height: number;
	wait: number;
	angle: Angle;
	createClass: any;
	angleSeq: any;//{[key:Angle]: number; };

	constructor(width:number, height:number, image:HTMLImageElement) {
		this.width = width;
		this.height = height;
		this.image = image;
		this.wait = 200;
		this.charaCol = 1;
		this.animeCnt = 2;
		this.moveTime = 20;
		this.movePixel = 64;
		this.angle = Angle.down;
		this.createClass = Character;
	}

	create(charaSeq:number, offset?: CommonOffset, angle?:Angle) {
		var c:Character = new this.createClass(
			this.width,
			this.height,
			this.image,
			this.wait
		);
		c.charaSeq = charaSeq;
		c.charaCol = this.charaCol;
		c.animeCnt = this.animeCnt;
		c.moveTime = this.moveTime;
		c.movePixel = this.movePixel;
		c.angle((angle == undefined) ? this.angle : angle)
		if (this.angleSeq)
			c.angleSeq = this.angleSeq;

		if (offset)
			c.moveTo(offset.x, offset.y);

		return c;
	}
}
