///<reference path="all.ts"/>
module jg {
	/**
	 * 方向
	 */
	export enum Angle {
		Unknown,
		Left,
		Right,
		Up,
		Down
	}

	/**
	 * 描画モード。Transfer = デフォルト、Flip = フリップ、Direct = 直接。
	 * jgame.jsでは動作に支障が無いことが確認出来る環境では、Directを使うことを推奨している。
	 */
	export enum RenderTransferMode {
		Unknown,
		Transfer,
		Flip,
		Direct
	}

	/**
	 * 入力イベント種別
	 */
	export enum InputEventType {
		Unknown,
		Keyboard,
		Point
	}

	/**
	 * 入力イベントの挙動
	 */
	export enum InputEventAction {
		Unknown,
		Down,
		Move,
		Up
	}

	/**
	 * キーの種別
	 */
	export enum Keytype {
		Unknown,
		Left,
		Right,
		Up,
		Down,
		Enter,
		Esc
	}

	/**
	 * Shapeの描画スタイル。塗りつぶす(Fill)か線(Stroke)かを指定。
	 */
	export enum ShapeStyle {
		/** 未定義 */
		Unknown,
		/**
		 * 線を描画
		 */
		Stroke,
		/**
		 * 
		 塗りつぶして描画
		 */
		Fill
	}

	/**
	 * Shapeの形状。
	 * Rectで四角、Arcで丸
	 */
	export enum ShapeType {
		Unknown,
		Rect,
		Arc
	}

	/**
	 * エフェクトの種類
	 */
	export enum EffectType {
		None,
		Fade,
		Mosaic,
		Blur,
		SlideUp,
		SlideDown,
		SlideLeft,
		SlideRight,
		WipeUp,
		WipeDown,
		WipeLeft,
		WipeRight,
		WipeFadeUp,
		WipeFadeDown,
		WipeFadeLeft,
		WipeFadeRight,
		BoxOut,
		BoxOut45,
		BoxIn,
		BoxIn45,
		ArcOut,
		ArcIn
	}
}