///<reference path="all.ts"/>
module jg {
	/**
	 * 曖昧に発火されるタイマー
	 */
	export class GameTimer {
		/** 前回発火時間 */
		tick: number;
		/** このタイマーの発火間隔 */
		wait: number;
		/** イベントハンドラ */
		trigger: Trigger;

		/**
		 * タイマーを生成する
		 * @param wait 発火間隔をミリ秒で指定
		 */
		constructor(wait:number) {
			this.wait = wait;
			this.tick = 0;
			this.trigger = new Trigger();
		}

		/**
		 * 発火を試みる
		 * @param t 経過時間
		 */
		tryFire(t:number) {
			this.tick += t;
			if (this.wait <= this.tick)
				this.fire();
		}

		/**
		 * 発火する
		 */
		fire() {
			// GameTimerは、あえて正確を度外視した大体の処理
			// ちゃんと差分とる場合はこう。 this.tick -= this.wait
			this.tick = 0;
			// 起動が保証されないfastFire
			this.trigger.fastFire(this);
		}
	}
}