module("Trigger");
test("new", function() {
	var trigger = new jg.Trigger();
	deepEqual(trigger.handlers, []);
});
test("fire1", function() {
	var trigger = new jg.Trigger();
	var a = {};
	var b = function() {
		strictEqual(this, a);
	}
	trigger.handle(a, b);
	trigger.fire();
});
test("fire2", function() {
	var trigger = new jg.Trigger();
	var a = {};
	var b = function() {
		strictEqual(this, b);
	}
	trigger.handle(b, b);
	trigger.fire();
});
test("fire3", function() {
	var trigger = new jg.Trigger();
	var c = 0;
	var a = {};
	var b = function() {
		c++;
	}
	trigger.handle(a, b);
	trigger.handle(a, b);
	trigger.handle(a, b);
	trigger.fire();
	deepEqual(c, 3);
});
test("fire4", function() {
	var trigger = new jg.Trigger();
	var c = 0;
	var a = {};
	var b = function() {
		c++;
		trigger.remove(a, b);
	}
	trigger.handle(a, b);
	trigger.handle(b, b);
	trigger.handle(a, b);
	trigger.fire();
	deepEqual(c, 3);
});
test("fastFire1", function() {
	var trigger = new jg.Trigger();
	var a = {};
	var b = function() {
		strictEqual(this, a);
	}
	trigger.handle(a, b);
	trigger.fastFire();
});
test("fastFire2", function() {
	var trigger = new jg.Trigger();
	var a = {};
	var b = function() {
		strictEqual(this, b);
	}
	trigger.handle(b, b);
	trigger.fastFire();
});
test("fastFire3", function() {
	var trigger = new jg.Trigger();
	var c = 0;
	var a = {};
	var b = function() {
		c++;
	}
	trigger.handle(a, b);
	trigger.handle(a, b);
	trigger.handle(a, b);
	trigger.fastFire();
	deepEqual(c, 3);
});
test("fastFire4", function() {
	var trigger = new jg.Trigger();
	var c = 0;
	var a = {};
	var b = function() {
		c++;
		//̏remove_handlers̐1ɂȂ邽߁Ahandle(b, b)΂Ȃ
		trigger.remove(a, b);
	}
	trigger.handle(a, b);
	trigger.handle(b, b);
	trigger.handle(a, b);
	trigger.fastFire();
	deepEqual(c, 1);
});


test("remove", function() {
	var trigger = new jg.Trigger();
	var c = {};
	var a = {};
	var b = function() {
	}
	trigger.handle(a, b);
	trigger.handle(b, b);
	trigger.handle(c, b);
	trigger.remove(a, b);
	deepEqual(trigger.handlers.length, 2);
	deepEqual(trigger.handlers[0].owner, b);
	deepEqual(trigger.handlers[0].handler, b);
	deepEqual(trigger.handlers[1].owner, c);
	deepEqual(trigger.handlers[1].handler, b);
});
test("removeAll", function() {
	var trigger = new jg.Trigger();
	var c = {};
	var a = {};
	var b = function() {
	}
	trigger.handle(a, b);
	trigger.handle(b, b);
	trigger.handle(c, b);
	trigger.handle(a, b);
	trigger.removeAll(a);
	deepEqual(trigger.handlers.length, 2);
	deepEqual(trigger.handlers[0].owner, b);
	deepEqual(trigger.handlers[0].handler, b);
	deepEqual(trigger.handlers[1].owner, c);
	deepEqual(trigger.handlers[1].handler, b);
});
test("removeAllByHandler", function() {
	var trigger = new jg.Trigger();
	var c = {};
	var a = {};
	var b = function() {
	}
	var d = function() {
	}
	trigger.handle(a, b);
	trigger.handle(a, d);
	trigger.handle(b, b);
	trigger.handle(b, d);
	trigger.handle(c, b);
	trigger.handle(d, b);
	trigger.removeAllByHandler(b);
	deepEqual(trigger.handlers.length, 2);
	deepEqual(trigger.handlers[0].owner, a);
	deepEqual(trigger.handlers[0].handler, d);
	deepEqual(trigger.handlers[1].owner, b);
	deepEqual(trigger.handlers[1].handler, d);
});
test("destroy", function() {
	var trigger = new jg.Trigger();
	var c = {};
	var a = {};
	var b = function() {
	}
	var d = function() {
	}
	trigger.handle(a, b);
	trigger.handle(a, d);
	trigger.handle(b, b);
	trigger.handle(b, d);
	trigger.destroy();
	trigger.handle(c, b);
	trigger.handle(d, b);
	deepEqual(trigger.handlers.length, 2);
	deepEqual(trigger.handlers[0].owner, c);
	deepEqual(trigger.handlers[0].handler, b);
	deepEqual(trigger.handlers[1].owner, d);
	deepEqual(trigger.handlers[1].handler, b);
});

test("handle", function() {
	var trigger = new jg.Trigger();
	var a = {};
	var b = function() {
	}
	trigger.handle(a, b);
	trigger.handle(b);
	deepEqual(trigger.handlers.length, 2);
	deepEqual(trigger.handlers[0].owner, a);
	deepEqual(trigger.handlers[0].handler, b);
	deepEqual(trigger.handlers[1].owner, window);
	deepEqual(trigger.handlers[1].handler, b);
});

test("handleInsert", function() {
	var trigger = new jg.Trigger();
	var a = {};
	var c = {}
	var b = function() {
	}
	trigger.handleInsert(0, a, b);
	trigger.handleInsert(0, b);
	trigger.handleInsert(1, c, b);
	deepEqual(trigger.handlers.length, 3);
	deepEqual(trigger.handlers[0].owner, window);
	deepEqual(trigger.handlers[0].handler, b);
	deepEqual(trigger.handlers[1].owner, c);
	deepEqual(trigger.handlers[1].handler, b);
	deepEqual(trigger.handlers[2].owner, a);
	deepEqual(trigger.handlers[2].handler, b);
});
