(function() {
	var game;
	module("scene", {
		setup: function( ){
			game = new jg.Game(480, 480);
		},
		teardown: function() {
			game.end();
			game.renderer.container.parentElement.removeChild(game.renderer.container);
		}
	})
	test("new", function() {
		var scene = new jg.Scene(game);
		deepEqual(scene.game, game);
	});
	test("changeScene", function() {
		var scene = new jg.Scene(game);
		var backup = game.scene;
		game.changeScene(scene);
		deepEqual(game.scene, scene);
		deepEqual(game.scenes[0], backup);
	});
	test("endScene and endGame", function() {
		game.endScene();
		deepEqual(game._exit, true);
	});
	test("endScene invalid call", function() {
		game.endScene();
		deepEqual(game._exit, true);
		game.endScene();
		deepEqual(game._exit, true);
	});
	test("change -> end", function() {
		var scene = new jg.Scene(game);
		game.changeScene(scene);
		deepEqual(game.scene, scene);
		game.endScene();
		deepEqual(game._exit, false);
		notDeepEqual(game.scene, scene);
	});
	test("change x2", function() {
		var scene = new jg.Scene(game);
		game.changeScene(scene);
		deepEqual(game.scene, scene);
		var scene2 = new jg.Scene(game);
		game.changeScene(scene2);
		deepEqual(game.scene, scene2);
		deepEqual(game.scenes[1], scene);
	});
	test("change x3", function() {
		var scene = new jg.Scene(game);
		game.changeScene(scene);
		deepEqual(game.scene, scene);
		var scene2 = new jg.Scene(game);
		game.changeScene(scene2);
		deepEqual(game.scene, scene2);
		var scene3 = new jg.Scene(game);
		game.changeScene(scene3);
		deepEqual(game.scene, scene3);
		deepEqual(game.scenes[1], scene);
		deepEqual(game.scenes[2], scene2);
	});

	test("show event", function() {
		var scene = new jg.Scene(game);
		var show_ok = false, start_ok = false;
		scene.showed.handle(function() {
			if (show_ok) {
				ok(false);
				return;
			}
			show_ok = true;
			ok(true);
		});
		scene.started.handle(function() {
			if (start_ok) {
				ok(false);
				return;
			}
			start_ok = true;
			ok(true);
		});
		game.changeScene(scene);
		ok(!show_ok);
		ok(start_ok);
		game.changeScene(new jg.Scene(game));
		ok(!show_ok);
		game.endScene();
		ok(show_ok);
	});

	test("hide event", function() {
		var scene = new jg.Scene(game);
		var hide_ok = false, end_ok = false;
		game.scene.hid.handle(function() {
			if (hide_ok) {
				ok(false);
				return;
			}
			hide_ok = true;
			ok(true);
		});
		scene.ended.handle(function() {
			if (end_ok) {
				ok(false);
				return;
			}
			end_ok = true;
			ok(true);
		});
		game.changeScene(scene);
		game.endScene();
		ok(hide_ok);
		ok(end_ok);
	});
})();
