///<reference path="all.ts"/>
module jg {
	/**
	 * 座標を示すインターフェース
	 */
	export interface CommonOffset {
		/** 横座標 */
		x: number;
		/** 縦座標 */
		y: number;
	}

	/**
	 * 大きさを示すインターフェース
	 */
	export interface CommonSize {
		/** 横幅 */
		width: number;
		/** 縦幅 */
		height: number;
	}

	/**
	 * 領域を示すインターフェース
	 */
	export interface CommonArea extends CommonOffset, CommonSize {
		
	}

	/**
	 * 四角形を現すインターフェース
	 */
	export interface IRectangle {
		/** 左位置 */
		left: number;
		/** 上位置 */
		top: number;
		/** 右位置 */
		right: number;
		/** 下位置 */
		bottom: number;
	}
}
