///<reference path="all.ts"/>
module jg {
	/**
	 * 画像をあらわす最も基本的な描画オブジェクト
	 */
	export class Sprite extends E {
		/** 描画対象の画像。HTMLImageElement, HTMLVideoElement, HTMLCanvasElementのいずれかが指定可能 */
		image: any; // HTMLImageElement, HTMLVideoElement, HTMLCanvasElement
		/** 転送元横幅。通常は画像と同サイズ */
		srcWidth: number;
		/** 転送元縦幅。通常は画尾と同サイズ */
		srcHeight: number;
		/** 転送元横座標。通常は0 */
		srcX: number;
		/** 転送元縦座標。通常は0 */
		srcY: number;

		/**
		 * Spriteクラスのインスタンスを生成する。
		 * @param image このSpriteをあらわす画像
		 * @param srcWidth 転送元横幅を指定。省略時は画像の横幅と同一になる
		 * @param srcHeight 転送元縦幅を指定。省略時は画像の縦幅と同一になる
		 */
		constructor(image:any, srcWidth?:number, srcHeight?:number) {
			super();
			this.x = 0;
			this.y = 0;
			this.width = srcWidth ? srcWidth : image.width;
			this.height = srcHeight ? srcHeight : image.height;
			this.srcWidth = this.width;
			this.srcHeight = this.height;
			this.srcX = 0;
			this.srcY = 0;
			this.image = image;
		}

		/**
		 * 描画する
		 * @paramn context 描画対象context
		 */
		draw(context:CanvasRenderingContext2D) {
			context.drawImage(
				this.image,
				this.srcX,
				this.srcY,
				this.srcWidth,
				this.srcHeight,
				0,
				0,
				this.width,
				this.height
			);
		}
/*
		refresh() {
			if (this.image instanceof HTMLCanvasElement) {
				//多分壊れてるが、復旧方法不明
			}
		}
*/
	}
}