///<reference path="all.ts"/>
module jg {
/*
Copyright (c) Ubiquitous Entertainment Inc. Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

	/**
	 * あらゆるAction関連イベントパラメータに格納されているパラメータ
	 */
	export interface ActionEventArgs {
		/** そのアクションが所属するTimelineクラス */
		timeline: Timeline;
	}

	/**
	 * 時間経過時のイベントパラメータ
	 */
	export interface ActionTickEventArgs extends ActionEventArgs {
		/** 経過時間 */
		elapsed: number;
	}

	/**
	 * 基本のアクション。Timelineクラスで利用される
	 */
	export class Action {
		/** このアクション完了までに要する時間 */
		time: number;
		/** 現在の経過時間 */
		frame: number;
		/** アクションごとに呼ばれるイベント。ActionEventArgsをパラメータとして持つ */
		added_to_timeline: Trigger;
		/** アクションごとに呼ばれるイベント。ActionEventArgsをパラメータとして持つ */
		removed_from_timeline: Trigger;
		/** アクションごとに呼ばれるイベント。ActionTickEventArgsをパラメータとして持つ */
		action_tick: Trigger;
		/** アクションごとに呼ばれるイベント。ActionEventArgsをパラメータとして持つ */
		action_start: Trigger;
		/** アクションごとに呼ばれるイベント。ActionEventArgsをパラメータとして持つ */
		action_end: Trigger;
		/** 所属するTimeline */
		timeline: Timeline;
		/** 操作対象のEntity  */
		entity: E;

		/**
		 * コンストラクタ
		 * @param param パラメータ一式
		 */
		constructor(param?:any) {
			this.added_to_timeline = new Trigger();
			this.removed_from_timeline = new Trigger();
			this.action_tick = new Trigger();

			this.time = null;
			this.frame = 0;
			if (param) {
				for (var key in param) {
					if (param.hasOwnProperty(key)) {
						if (param[key] != null) {
							this[key] = param[key];
						}
					}
				}
			}
			var action = this;

			this.timeline = null;
			this.entity = null;

			this.removed_from_timeline.handle(this, this.removedFromTimeline);
			this.added_to_timeline.handle(this, this.addedToTimeline);
			this.action_tick.handle(this, this.actionTick);
		}

		/**
		 * removed_from_timelineイベントのイベントハンドラ
		 */
		removedFromTimeline() {
			this.timeline = null;
			this.entity = null;
			this.frame = 0;
		}

		/**
		 * added_to_timelineイベントのイベントハンドラ
		 */
		addedToTimeline(p:ActionEventArgs) {
			this.timeline = p.timeline;
			this.entity = p.timeline.entity;
			this.frame = 0;
		}

		/**
		 * action_tickイベントのイベントハンドラ
		 */
		actionTick(p:ActionTickEventArgs) {
			var remaining = this.time - (this.frame + p.elapsed);
			if (this.time != null && remaining <= 0) {
				this.frame = this.time;
				p.timeline.next(-remaining);
			} else {
				this.frame += p.elapsed;
			}
		}
	}
}