class Resource {
	images: {[key:string]: HTMLImageElement; };
	scripts: {[key:string]: HTMLScriptElement; };
	sounds: {[key:string]: any; };
	requests: any[];
	loaded: Trigger;
	loaders: {[key:string]: ResourceLoader; };

	static instance:Resource;

	static getInstance():Resource {
		return () => {
			if (! Resource.instance)
				Resource.instance = new Resource();
			return Resource.instance;
		}();
	}

	constructor() {
		this.requests = [];
		this.loaded = new Trigger();
		this.images = {};
		this.scripts = {};
		this.sounds = {};
		this.loaders = {};
		this.loaders["js"] = new ScriptResourceLoader(this);
		this.loaders["default"] = new ImageResourceLoader(this);
		this.loaders["mp3"] = new SoundResourceLoader(this);
		this.loaders["ogg"] = this.loaders["mp3"];
		this.loaders["wav"] = this.loaders["mp3"];
		this.loaders["mid"] = this.loaders["mp3"];
	}

	get(name:string) {
		return this.images[name];
	}

	sound(name:string) {
		return this.sounds[name];
	}

	requestCompleted(name:string) {
		for (var i=0; i<this.requests.length; i++) {
			if (this.requests[i] == name) {
				this.requests.splice(i, 1);
				break;
			}
		}
		this.loaded.fire(this.requests.length);
	}

	load(name:string, url?:string) {
		if (! url)
			url = name;


		this.requests.push(name);

		var dot = url.split(/\./g);
		var ext;
		if (dot.length == 0)
			ext = "";
		else
			ext = dot[dot.length - 1];

		ext = ext.toLowerCase();
		if (this.loaders[ext])
			this.loaders[ext].load(url, name);
		else
			this.loaders["default"].load(url, name);
	}
}