interface CommonOffset {
	x: number;
	y: number;
}
interface CommonSize {
	w: number;
	h: number;
}
class Rectangle {
	left:number;
	top:number;
	right:number;
	bottom:number;

	constructor(left?:number, top?:number, right?:number, bottom?:number) {
		this.left = left;
		this.top = top;
		this.right = right;
		this.bottom = bottom;
	}

	hitTest(point:CommonOffset) {
		return (this.left <= point.x && this.right >= point.x && this.top <= point.y && this.bottom >= point.y);
	}
}

class Area {
	x: number;
	y: number;
	width: number;
	height: number;

	constructor(x:number, y:number, width:number, height:number) {
		this.x = x;
		this.y = y;
		this.width = width;
		this.height = height;
	}
}
