﻿/* テスト */
/* 
 * Debug Status: Not checked.
 * - Fixed __T on this page.
 */
/*
 * File: cmd3.c
 * Purpose: Miscellaneous queries
 *
 * Copyright (c) 1997 Ben Harrison, James E. Wilson, Robert A. Koeneke
 *
 * This work is free software; you can redistribute it and/or modify it
 * under the terms of either:
 *
 * a) the GNU General Public License as published by the Free Software
 *    Foundation, version 2, or
 *
 * b) the "Angband licence":
 *    This software may be copied and distributed for educational, research,
 *    and not for profit purposes provided that this copyright and statement
 *    are included in all such copies.  Other copyrights may also apply.
 */
extern "C"
{
#include "angband.h"
#include "object/tvalsval.h"

#include "cmds.h"
}
extern bool get_item(int *cp, const _TCHAR *pmt, const _TCHAR *str, int mode);
extern void redraw_stuff(void);
extern int button_add(const _TCHAR *label, _TCHAR keypress);
extern ui_event_data inkey_ex(void);
extern void screen_save(void);
extern void screen_load(void);
extern void msg_print(const _TCHAR *msg);
extern errr cmd_insert(cmd_code c, ...);
extern void bell(const _TCHAR *reason);
extern int button_kill(_TCHAR keypress);
extern bool get_check(const _TCHAR *prompt);
extern void prt(const _TCHAR *str, int row, int col);
extern void put_str(const _TCHAR *str, int row, int col);
extern char index_to_label(int i);
extern size_t object_desc(_TCHAR *buf, size_t max, const object_type *o_ptr, bool prefix, int mode);
extern size_t strnfmt(_TCHAR *buf, size_t max, const _TCHAR *fmt, ...);

/*
 * Display inventory
 */
void do_cmd_inven(void)
{
	/* Hack -- Start in "inventory" mode */
	p_ptr->command_wrk = (USE_INVEN);

	/* Save screen */
	screen_save();

	/* Hack -- show empty slots */
	item_tester_full = TRUE;

	/* Display the inventory */
	show_inven();

	/* Hack -- hide empty slots */
	item_tester_full = FALSE;

	/* Prompt for a command */
	prt(format(__T("(Inventory) Burden %d.%dlb (%d%% capacity). Command: "),
	    p_ptr->total_weight / 10, p_ptr->total_weight % 10,
	    (10 * p_ptr->total_weight) / (6 * adj_str_wgt[p_ptr->state.stat_ind[A_STR]])), 0, 0);

	/* Hack -- Get a new command */
	p_ptr->command_new = inkey();

	/* Load screen */
	screen_load();


	/* Hack -- Process "Escape" */
	if (p_ptr->command_new == ESCAPE)
	{
		/* Reset stuff */
		p_ptr->command_new = 0;
	}
}

/*
 * Display equipment
 */
void do_cmd_equip(void)
{
	/* Hack -- Start in "equipment" mode */
	p_ptr->command_wrk = (USE_EQUIP);

	/* Save screen */
	screen_save();

	/* Hack -- show empty slots */
	item_tester_full = TRUE;

	/* Display the equipment */
	show_equip();

	/* Hack -- undo the hack above */
	item_tester_full = FALSE;

	/* Prompt for a command */
	prt(__T("(Equipment) Command: "), 0, 0);

	/* Hack -- Get a new command */
	p_ptr->command_new = inkey();

	/* Load screen */
	screen_load();

	/* Hack -- Process "Escape" */
	if (p_ptr->command_new == ESCAPE)
	{
		/* Reset stuff */
		p_ptr->command_new = 0;
	}
}

/*
 * Wield or wear a single item from the pack or floor
 */
void wield_item(object_type *o_ptr, int item)
{
	object_type object_type_body;
	object_type *i_ptr = &object_type_body;

	const _TCHAR *act;
	_TCHAR o_name[80];

	int slot = wield_slot(o_ptr);

	/* Take a turn */
	p_ptr->energy_use = 100;

	/* Obtain local object */
	object_copy(i_ptr, o_ptr);

	/* Modify quantity */
	i_ptr->number = 1;

	/* Decrease the item (from the pack) */
	if (item >= 0)
	{
		inven_item_increase(item, -1);
		inven_item_optimize(item);
	}
	else /* Decrease the item (from the floor) */
	{
		floor_item_increase(0 - item, -1);
		floor_item_optimize(0 - item);
	}
	/* Get the wield slot */
	o_ptr = &inventory[slot];

	/* Take off existing item */
	if (o_ptr->k_idx)
	{
		/* Take off existing item */
		(void)inven_takeoff(slot, 255);
	}
	/* Wear the new stuff */
	object_copy(o_ptr, i_ptr);

	/* Increase the weight */
	p_ptr->total_weight += i_ptr->weight;

	/* Increment the equip counter by hand */
	p_ptr->equip_cnt++;

	/* Do any ID-on-wield */
	object_tried(o_ptr);
	object_notice_on_wield(o_ptr);

	/* Where is the item now */
	if (slot == INVEN_WIELD)
		act = __T("You are wielding");
	else if (slot == INVEN_BOW)
		act = __T("You are shooting with");
	else if (slot == INVEN_LITE)
		act = __T("Your light source is");
	else
		act = __T("You are wearing");

	/* Describe the result */
	object_desc(o_name, _countof(o_name), o_ptr, TRUE, ODESC_FULL);

	/* Message */
	sound(MSG_WIELD);
	msg_format(__T("%s %s (%c)."), act, o_name, index_to_label(slot));

	/* Cursed! */
	if (cursed_p(o_ptr))
	{
		/* Warn the player */
		sound(MSG_CURSED);
		msg_print(LS(__T("Oops! It feels deathly cold!"),__T("[未訳]Untranslated text. Copy or Translate from English.")));

		/* Sense the object */
		object_notice_curses(o_ptr);
	}

	/* Recalculate bonuses, torch, mana */
	p_ptr->update |= (PU_BONUS | PU_TORCH | PU_MANA);
	p_ptr->redraw |= (PR_INVEN | PR_EQUIP);
}

void do_cmd_destroy(cmd_code code, cmd_arg args[]) 
{ 
	int item, amt; 

	object_type *o_ptr; 

	object_type destroyed_obj;

	_TCHAR o_name[120]; 

	item = args[0].item; 
	amt = args[1].number; 

	/* Destroying squelched items is easy. */ 
	if (item == ALL_SQUELCHED) 
	{ 
		squelch_items(); 
		return; 
	} 
	if (!item_is_available(item, NULL, USE_INVEN | USE_EQUIP | USE_FLOOR)) 
	{ 
		msg_print(LS(__T("You do not have that item to destroy it."),__T("[未訳]Untranslated text. Copy or Translate from English."))); 
		return; 
	}
	o_ptr = object_from_item_idx(item);

	/* Can't destroy cursed items we're wielding. */
	if ((item >= INVEN_WIELD) && cursed_p(o_ptr))
	{
		msg_print(LS(__T("You cannot destroy the cursed item."),__T("[未訳]Untranslated text. Copy or Translate from English.")));
		return;
	}
	/* Describe the destroyed object by taking a copy with the right "amt" */ 
	object_copy_amt(&destroyed_obj, o_ptr, amt); 
	object_desc(o_name, _countof(o_name), &destroyed_obj, TRUE, ODESC_FULL);

	/* Artifacts cannot be destroyed */
	if (artifact_p(o_ptr))
	{
		/* Message */
		msg_format(__T("You cannot destroy %s."), o_name);
		o_ptr->ident |= IDENT_INDESTRUCT;

		/* Combine the pack */
		p_ptr->notice |= (PN_COMBINE);

		/* Redraw stuff */
		p_ptr->redraw |= (PR_INVEN | PR_EQUIP);

		/* Done */
		return;
	}
	/* Message */
	message_format(MSG_DESTROY, 0, __T("You destroy %s."), o_name);

	/* Reduce the charges of rods/wands/staves */
	reduce_charges(o_ptr, amt);

	/* Eliminate the item (from the pack) */
	if (item >= 0)
	{
		inven_item_increase(item, -amt);
		inven_item_describe(item);
		inven_item_optimize(item);
	}
	else /* Eliminate the item (from the floor) */
	{
		floor_item_increase(0 - item, -amt);
		floor_item_describe(0 - item);
		floor_item_optimize(0 - item);
	}
} 

/*
 * Destroy an item
 */
void textui_cmd_destroy(void)
{
	int item, amt;
	object_type *o_ptr;
	object_type obj_to_destroy;

	_TCHAR o_name[120];
	_TCHAR out_val[160];

	const _TCHAR *q; 
	const _TCHAR *s;

	/* Get an item */
	q = __T("Destroy which item? ");
	s = __T("You have nothing to destroy.");
	if (!get_item(&item, q, s, (USE_INVEN | USE_EQUIP | USE_FLOOR | CAN_SQUELCH))) return;

	/* Deal with squelched items */
	if (item == ALL_SQUELCHED)
	{
		cmd_insert(CMD_DESTROY, item, 0);
		return;
	}
	o_ptr = object_from_item_idx(item);

	/* Get a quantity */
	amt = get_quantity(NULL, o_ptr->number);
	if (amt <= 0) return;

	/* Describe the destroyed object by taking a copy with the right "amt" */ 
	object_copy_amt(&obj_to_destroy, o_ptr, amt); 
	object_desc(o_name, _countof(o_name), &obj_to_destroy, TRUE, ODESC_FULL);

	/* Verify destruction */
	strnfmt(out_val, _countof(out_val), __T("Really destroy %s? "), o_name);
	if (!get_check(out_val)) return;

	/* Tell the game to destroy the item. */
	cmd_insert(CMD_DESTROY, item, amt);

	/* Check for squelching */
	if (squelch_tval(o_ptr->tval))
	{
		_TCHAR sval_name[50];

		/* Obtain plural form without a quantity */
		object_desc(sval_name, sizeof sval_name, o_ptr, FALSE,
				ODESC_BASE | ODESC_PLURAL);
		strnfmt(out_val, sizeof out_val, __T("Ignore %s in future? "),
				sval_name);

		if (get_check(out_val))
		{
			/* squelch_set_squelch(tval, sval); */
			k_info[o_ptr->k_idx].squelch = TRUE;
			p_ptr->notice |= PN_SQUELCH;
			msg_format(__T("Ignoring %s from now on."), sval_name);
		}		
	}
}

void refill_lamp(object_type *j_ptr, object_type *o_ptr, int item)
{
	/* Refuel */
	j_ptr->timeout += o_ptr->timeout ? o_ptr->timeout : o_ptr->pval;

	/* Message */
	msg_print(LS(__T("You fuel your lamp."),__T("[未訳]Untranslated text. Copy or Translate from English.")));

	/* Comment */
	if (j_ptr->timeout >= FUEL_LAMP)
	{
		j_ptr->timeout = FUEL_LAMP;
		msg_print(LS(__T("Your lamp is full."),__T("[未訳]Untranslated text. Copy or Translate from English.")));
	}
	/* Refilled from a lantern */
	if (o_ptr->sval == SV_LITE_LANTERN)
	{
		/* Unstack if necessary */
		if (o_ptr->number > 1)
		{
			object_type *i_ptr;
			object_type object_type_body;

			/* Get local object */
			i_ptr = &object_type_body;

			/* Obtain a local object */
			object_copy(i_ptr, o_ptr);

			/* Modify quantity */
			i_ptr->number = 1;

			/* Remove fuel */
			i_ptr->timeout = 0;

			/* Unstack the used item */
			o_ptr->number--;
			p_ptr->total_weight -= i_ptr->weight;

			/* Carry or drop */
			if (item >= 0)
				item = inven_carry(i_ptr);
			else
				drop_near(i_ptr, 0, p_ptr->py, p_ptr->px);
		}
		else /* Empty a single lantern */
		{
			/* No more fuel */
			o_ptr->timeout = 0;
		}
		/* Combine / Reorder the pack (later) */
		p_ptr->notice |= (PN_COMBINE | PN_REORDER);

		/* Redraw stuff */
		p_ptr->redraw |= (PR_INVEN);
	}
	/* Refilled from a flask */
	else
	{
		/* Decrease the item (from the pack) */
		if (item >= 0)
		{
			inven_item_increase(item, -1);
			inven_item_describe(item);
			inven_item_optimize(item);
		}
		else /* Decrease the item (from the floor) */
		{
			floor_item_increase(0 - item, -1);
			floor_item_describe(0 - item);
			floor_item_optimize(0 - item);
		}
	}
	/* Recalculate torch */
	p_ptr->update |= (PU_TORCH);

	/* Redraw stuff */
	p_ptr->redraw |= (PR_EQUIP);
}

void refuel_torch(object_type *j_ptr, object_type *o_ptr, int item)
{
	/* Refuel */
	j_ptr->timeout += o_ptr->timeout + 5;

	/* Message */
	msg_print(LS(__T("You combine the torches."),__T("[未訳]Untranslated text. Copy or Translate from English.")));

	/* Over-fuel message */
	if (j_ptr->timeout >= FUEL_TORCH)
	{
		j_ptr->timeout = FUEL_TORCH;
		msg_print(LS(__T("Your torch is fully fueled."),__T("[未訳]Untranslated text. Copy or Translate from English.")));
	}
	else /* Refuel message */
	{
		msg_print(LS(__T("Your torch glows more brightly."),__T("[未訳]Untranslated text. Copy or Translate from English.")));
	}
	/* Decrease the item (from the pack) */
	if (item >= 0)
	{
		inven_item_increase(item, -1);
		inven_item_describe(item);
		inven_item_optimize(item);
	}
	else /* Decrease the item (from the floor) */
	{
		floor_item_increase(0 - item, -1);
		floor_item_describe(0 - item);
		floor_item_optimize(0 - item);
	}
	/* Recalculate torch */
	p_ptr->update |= (PU_TORCH);

	/* Redraw stuff */
	p_ptr->redraw |= (PR_EQUIP);
}

/*
 * Target command
 */
void do_cmd_target(void)
{
	/* Target set */
	if (target_set_interactive(TARGET_KILL, -1, -1))
	{
		msg_print(LS(__T("Target Selected."),__T("[未訳]Untranslated text. Copy or Translate from English.")));
	}
	else /* Target aborted */
	{
		msg_print(LS(__T("Target Aborted."),__T("[未訳]Untranslated text. Copy or Translate from English.")));
	}
}

/*
 * Look command
 */
void do_cmd_look(void)
{
	/* Look around */
	if (target_set_interactive(TARGET_LOOK, -1, -1))
	{
		msg_print(LS(__T("Target Selected."),__T("[未訳]Untranslated text. Copy or Translate from English.")));
	}
}

/*
 * Allow the player to examine other sectors on the map
 */
void do_cmd_locate(void)
{
	int dir, y1, x1, y2, x2;

	_TCHAR tmp_val[80];
	_TCHAR out_val[160];

	/* Start at current panel */
	y1 = Term->offset_y;
	x1 = Term->offset_x;

	/* Show panels until done */
	while (1)
	{
		/* Get the current panel */
		y2 = Term->offset_y;
		x2 = Term->offset_x;
		
		/* Describe the location */
		if ((y2 == y1) && (x2 == x1))
		{
			tmp_val[0] = 0;
		}
		else
		{
			strnfmt(tmp_val, _countof(tmp_val), __T("%s%s of"),
			        ((y2 < y1) ? __T(" north") : (y2 > y1) ? __T(" south") : __T("")),
			        ((x2 < x1) ? __T(" west") : (x2 > x1) ? __T(" east") : __T("")));
		}
		/* Prepare to ask which way to look */
		strnfmt(out_val, _countof(out_val),
		        __T("Map sector [%d,%d], which is%s your sector.  Direction?"),
		        (y2 / PANEL_HGT), (x2 / PANEL_WID), tmp_val);

		/* More detail */
		if (OPT(center_player))
		{
			strnfmt(out_val, _countof(out_val),
		        	__T("Map sector [%d(%02d),%d(%02d)], which is%s your sector.  Direction?"),
		        	(y2 / PANEL_HGT), (y2 % PANEL_HGT),
		        	(x2 / PANEL_WID), (x2 % PANEL_WID), tmp_val);
		}
		/* Assume no direction */
		dir = 0;

		/* Get a direction */
		while (!dir)
		{
			_TCHAR command;

			/* Get a command (or Cancel) */
			if (!get_com(out_val, &command)) break;

			/* Extract direction */
			dir = target_dir(command);

			/* Error */
			if (!dir) 
				bell(__T("Illegal direction for locate!"));
		}
		/* No direction */
		if (!dir) break;

		/* Apply the motion */
		change_panel(dir);

		/* Handle stuff */
		handle_stuff();
	}
	/* Verify panel */
	verify_panel();
}

/*
 * The table of "symbol info" -- each entry is a string of the form
 * "X:desc" where "X" is the trigger, and "desc" is the "info".
 */
static const _TCHAR *ident_info[] =
{
	__T(" :A dark grid"),
	__T("!:A potion (or oil)"),
	__T("\":An amulet (or necklace)"),
	__T("#:A wall (or secret door)"),
	__T("$:Treasure (gold or gems)"),
	__T("%:A vein (magma or quartz)"),
	/* "&:unused", */
	__T("':An open door"),
	__T("(:Soft armor"),
	__T("):A shield"),
	__T("*:A vein with treasure"),
	__T("+:A closed door"),
	__T(",:Food (or mushroom patch)"),
	__T("-:A wand (or rod)"),
	__T(".:Floor"),
	__T("/:A polearm (Axe/Pike/etc)"),
	/* "0:unused", */
	__T("1:Entrance to General Store"),
	__T("2:Entrance to Armory"),
	__T("3:Entrance to Weaponsmith"),
	__T("4:Entrance to Temple"),
	__T("5:Entrance to Alchemy shop"),
	__T("6:Entrance to Magic store"),
	__T("7:Entrance to Black Market"),
	__T("8:Entrance to your home"),
	/* "9:unused", */
	__T("::Rubble"),
	__T(";:A glyph of warding"),
	__T("<:An up staircase"),
	__T("=:A ring"),
	__T(">:A down staircase"),
	__T("?:A scroll"),
	__T("@:You"),
	__T("A:Angel"),
	__T("B:Bird"),
	__T("C:Canine"),
	__T("D:Ancient Dragon/Wyrm"),
	__T("E:Elemental"),
	__T("F:Dragon Fly"),
	__T("G:Ghost"),
	__T("H:Hybrid"),
	__T("I:Insect"),
	__T("J:Snake"),
	__T("K:Killer Beetle"),
	__T("L:Lich"),
	__T("M:Multi-Headed Reptile"),
	/* "N:unused", */
	__T("O:Ogre"),
	__T("P:Giant Humanoid"),
	__T("Q:Quylthulg (Pulsing Flesh Mound)"),
	__T("R:Reptile/Amphibian"),
	__T("S:Spider/Scorpion/Tick"),
	__T("T:Troll"),
	__T("U:Major Demon"),
	__T("V:Vampire"),
	__T("W:Wight/Wraith/etc"),
	__T("X:Xorn/Xaren/etc"),
	__T("Y:Yeti"),
	__T("Z:Zephyr Hound"),
	__T("[:Hard armor"),
	__T("\\:A hafted weapon (mace/whip/etc)"),
	__T("]:Misc. armor"),
	__T("^:A trap"),
	__T("_:A staff"),
	/* "`:unused", */
	__T("a:Ant"),
	__T("b:Bat"),
	__T("c:Centipede"),
	__T("d:Dragon"),
	__T("e:Floating Eye"),
	__T("f:Feline"),
	__T("g:Golem"),
	__T("h:Hobbit/Elf/Dwarf"),
	__T("i:Icky Thing"),
	__T("j:Jelly"),
	__T("k:Kobold"),
	__T("l:Louse"),
	__T("m:Mold"),
	__T("n:Naga"),
	__T("o:Orc"),
	__T("p:Person/Human"),
	__T("q:Quadruped"),
	__T("r:Rodent"),
	__T("s:Skeleton"),
	__T("t:Townsperson"),
	__T("u:Minor Demon"),
	__T("v:Vortex"),
	__T("w:Worm/Worm-Mass"),
	/* "x:unused", */
	__T("y:Yeek"),
	__T("z:Zombie/Mummy"),
	__T("{:A missile (arrow/bolt/shot)"),
	__T("|:An edged weapon (sword/dagger/etc)"),
	__T("}:A launcher (bow/crossbow/sling)"),
	__T("~:A tool (or miscellaneous item)"),
	NULL
};

/*
 * Sorting hook -- Comp function -- see below
 *
 * We use "u" to point to array of monster indexes,
 * and "v" to select the type of sorting to perform on "u".
 */
bool ang_sort_comp_hook(const void *u, const void *v, int a, int b)
{
	const u16b *who = (const u16b *)(u);
	const u16b *why = (const u16b *)(v);

	int w1 = who[a];
	int w2 = who[b];

	int z1, z2;


	/* Sort by player kills */
	if (*why >= 4)
	{
		/* Extract player kills */
		z1 = l_list[w1].pkills;
		z2 = l_list[w2].pkills;

		/* Compare player kills */
		if (z1 < z2) return (TRUE);
		if (z1 > z2) return (FALSE);
	}
	/* Sort by total kills */
	if (*why >= 3)
	{
		/* Extract total kills */
		z1 = l_list[w1].tkills;
		z2 = l_list[w2].tkills;

		/* Compare total kills */
		if (z1 < z2) return (TRUE);
		if (z1 > z2) return (FALSE);
	}
	/* Sort by monster level */
	if (*why >= 2)
	{
		/* Extract levels */
		z1 = r_info[w1].level;
		z2 = r_info[w2].level;

		/* Compare levels */
		if (z1 < z2) return (TRUE);
		if (z1 > z2) return (FALSE);
	}
	/* Sort by monster experience */
	if (*why >= 1)
	{
		/* Extract experience */
		z1 = r_info[w1].mexp;
		z2 = r_info[w2].mexp;

		/* Compare experience */
		if (z1 < z2) return (TRUE);
		if (z1 > z2) return (FALSE);
	}

	/* Compare indexes */
	return (w1 <= w2);
}

/*
 * Sorting hook -- Swap function -- see below
 *
 * We use "u" to point to array of monster indexes,
 * and "v" to select the type of sorting to perform.
 */
void ang_sort_swap_hook(void *u, void *v, int a, int b)
{
	u16b *who = (u16b*)(u);
	u16b holder;

	UNREFERENCED_PARAMETER(v);

	/* Swap */
	holder = who[a];
	who[a] = who[b];
	who[b] = holder;
}

/*
 * Identify a character, allow recall of monsters
 *
 * Several "special" responses recall "multiple" monsters:
 *   ^A (all monsters)
 *   ^U (all unique monsters)
 *   ^N (all non-unique monsters)
 *
 * The responses may be sorted in several ways, see below.
 *
 * Note that the player ghosts are ignored, since they do not exist.
 */
void do_cmd_query_symbol(void)
{
	int i, n, r_idx;
	_TCHAR sym;
	_TCHAR buf[128];

	ui_event_data query;

	bool all = FALSE;
	bool uniq = FALSE;
	bool norm = FALSE;

	bool recall = FALSE;

	u16b why = 0;
	u16b *who;

	/* Get a character, or abort */
	if (!get_com(__T("Enter character to be identified, or control+[ANU]: "), &sym)) return;

	/* Find that character info, and describe it */
	for (i = 0; ident_info[i]; ++i)
	{
		if (sym == ident_info[i][0]) break;
	}
	/* Describe */
	if (sym == KTRL('A'))
	{
		all = TRUE;
		_tcscpy_s(buf, _countof(buf), __T("Full monster list."));
	}
	else if (sym == KTRL('U'))
	{
		all = uniq = TRUE;
		_tcscpy_s(buf, _countof(buf), __T("Unique monster list."));
	}
	else if (sym == KTRL('N'))
	{
		all = norm = TRUE;
		_tcscpy_s(buf, _countof(buf), __T("Non-unique monster list."));
	}
	else if (ident_info[i])
	{
		strnfmt(buf, _countof(buf), __T("%c - %s."), sym, ident_info[i] + 2);
	}
	else
	{
		strnfmt(buf, _countof(buf), __T("%c - %s."), sym, __T("Unknown Symbol"));
	}
	/* Display the result */
	prt(buf, 0, 0);

	/* Allocate the "who" array */
	who = C_ZNEW(z_info->r_max, u16b);

	/* Collect matching monsters */
	for (n = 0, i = 1; i < z_info->r_max - 1; i++)
	{
		monster_race *r_ptr = &r_info[i];
		monster_lore *l_ptr = &l_list[i];

		/* Nothing to recall */
		if (!OPT(cheat_know) && !l_ptr->sights) continue;

		/* Require non-unique monsters if needed */
		if (norm && (r_ptr->flags[0] & (RF0_UNIQUE))) continue;

		/* Require unique monsters if needed */
		if (uniq && !(r_ptr->flags[0] & (RF0_UNIQUE))) continue;

		/* Collect "appropriate" monsters */
		if (all || (r_ptr->d_char == sym)) who[n++] = i;
	}
	/* Nothing to recall */
	if (!n)
	{
		/* XXX XXX Free the "who" array */
		FREE(who);

		return;
	}
	/* Buttons */
	button_add(__T("[y]"), 'y');
	button_add(__T("[k]"), 'k');
	/* Don't collide with the repeat button */
	button_add(__T("[n]"), 'q'); 
	redraw_stuff();

	/* Prompt */
	put_str(__T("Recall details? (y/k/n): "), 0, 40);

	/* Query */
	query = inkey_ex();

	/* Restore */
	prt(buf, 0, 0);

	/* Buttons */
	button_kill('y');
	button_kill('k');
	button_kill('q');
	redraw_stuff();

	/* Interpret the response */
	if (query.key == 'k')
	{
		/* Sort by kills (and level) */
		why = 4;
	}
	else if (query.key == 'y' || query.key == 'p')
	{
		/* Sort by level; accept 'p' as legacy */
		why = 2;
	}
	else
	{
		/* Any unsupported response is "nope, no history please" */
	
		/* XXX XXX Free the "who" array */
		FREE(who);

		return;
	}

	/* Select the sort method */
	ang_sort_comp = ang_sort_comp_hook;
	ang_sort_swap = ang_sort_swap_hook;

	/* Sort the array */
	ang_sort(who, &why, n);

	/* Start at the end */
	i = n - 1;

	/* Button */
	button_add(__T("[r]"), 'r');
	button_add(__T("[-]"), '-');
	button_add(__T("[+]"), '+');
	redraw_stuff();

	/* Scan the monster memory */
	while (1)
	{
		/* Extract a race */
		r_idx = who[i];

		/* Hack -- Auto-recall */
		monster_race_track(r_idx);

		/* Hack -- Handle stuff */
		handle_stuff();

		/* Hack -- Begin the prompt */
		roff_top(r_idx);

		/* Hack -- Complete the prompt */
		Term_addstr(-1, TERM_WHITE, __T(" [(r)ecall, ESC]"));

		/* Interact */
		while (1)
		{
			/* Recall */
			if (recall)
			{
				/* Save screen */
				screen_save();

				/* Recall on screen */
				screen_roff(who[i]);

				/* Hack -- Complete the prompt (again) */
				Term_addstr(-1, TERM_WHITE, __T(" [(r)ecall, ESC]"));
			}
			/* Command */
			query = inkey_ex();

			/* Unrecall */
			if (recall)
			{
				/* Load screen */
				screen_load();
			}

			/* Normal commands */
			if (query.key != 'r') break;

			/* Toggle recall */
			recall = !recall;
		}

		/* Stop scanning */
		if (query.key == ESCAPE) break;

		/* Move to "prev" monster */
		if (query.key == '-')
		{
			if (++i == n)
				i = 0;
		}
		else /* Move to "next" monster */
		{
			if (i-- == 0)
				i = n - 1;
		}
	}
	/* Button */
	button_kill('r');
	button_kill('-');
	button_kill('+');
	redraw_stuff();

	/* Re-display the identity */
	prt(buf, 0, 0);

	/* Free the "who" array */
	FREE(who);
}
