/* テスト */
/*
 * Debug Status: Not checked.
 * - Fixed __T on this page.
 */
/*
 * File: variable.c
 * Purpose: Various global variables
 *
 * Copyright (c) 1997 Ben Harrison, James E. Wilson, Robert A. Koeneke
 *
 * This work is free software; you can redistribute it and/or modify it
 * under the terms of either:
 *
 * a) the GNU General Public License as published by the Free Software
 *    Foundation, version 2, or
 *
 * b) the "Angband licence":
 *    This software may be copied and distributed for educational, research,
 *    and not for profit purposes provided that this copyright and statement
 *    are included in all such copies.  Other copyrights may also apply.
 */
extern "C"
{
#include "angband.h"
}

/*
 * Hack -- Link a copyright message into the executable
 */
const _TCHAR *copyright =
	__T("Copyright (c) 1987-2007 Angband contributors.\n")
	__T("\n")
	__T("This work is free software; you can redistribute it and/or modify it\n")
	__T("under the terms of either:\n")
	__T("\n")
	__T("a) the GNU General Public License as published by the Free Software\n")
	__T("   Foundation, version 2, or\n")
	__T("\n")
	__T("b) the Angband licence:\n")
	__T("   This software may be copied and distributed for educational, research,\n")
	__T("   and not for profit purposes provided that this copyright and statement\n")
	__T("   are included in all such copies.  Other copyrights may also apply.\n";)

/*
 * Executable version
 */
byte version_major = VERSION_MAJOR;
byte version_minor = VERSION_MINOR;
byte version_patch = VERSION_PATCH;
byte version_extra = VERSION_EXTRA;

/*
 * Savefile version
 */
byte sf_major;			/* Savefile's "version_major" */
byte sf_minor;			/* Savefile's "version_minor" */
byte sf_patch;			/* Savefile's "version_patch" */
byte sf_extra;			/* Savefile's "version_extra" */

/*
 * Run-time arguments
 */
bool arg_wizard;			/* Command arg -- Request wizard mode */
bool arg_rebalance;			/* Command arg -- Rebalance monsters */
int arg_graphics;			/* Command arg -- Request graphics mode */
int arg_language;			/* Command arg -- Select language */
/*
 * Various things
 */

bool character_generated;	/* The character exists */
bool character_dungeon;		/* The character has a dungeon */
bool character_saved;		/* The character was just saved to a savefile */

s16b character_icky;		/* Depth of the game in special mode */
s16b character_xtra;		/* Depth of the game in startup mode */

u32b seed_randart;		/* Hack -- consistent random artifacts */

u32b seed_flavor;		/* Hack -- consistent object colors */
u32b seed_town;			/* Hack -- consistent town layout */

s16b num_repro;			/* Current reproducer count */

_TCHAR summon_kin_type;		/* Hack -- See summon_specific() */

s32b turn;				/* Current game turn */

s32b old_turn;			/* Hack -- Level feeling counter */

int use_graphics;		/* The "graphics" mode is enabled */
bool use_bigtile = FALSE;

s16b signal_count;		/* Hack -- Count interrupts */

bool msg_flag;			/* Player has pending message */

bool inkey_base;		/* See the "inkey()" function */
bool inkey_xtra;		/* See the "inkey()" function */
u32b inkey_scan;		/* See the "inkey()" function */
bool inkey_flag;		/* See the "inkey()" function */

bool opening_chest;		/* Hack -- prevent chest generation */

bool shimmer_monsters;	/* Hack -- optimize multi-hued monsters */
bool shimmer_objects;	/* Hack -- optimize multi-hued objects */

bool repair_mflag_nice;	/* Hack -- repair monster flags (nice) */
bool repair_mflag_show;	/* Hack -- repair monster flags (show) */
bool repair_mflag_mark;	/* Hack -- repair monster flags (mark) */

s16b o_max = 1;			/* Number of allocated objects */
s16b o_cnt = 0;			/* Number of live objects */

u16b mon_max = 1;	/* Number of allocated monsters */
s16b mon_cnt = 0;	/* Number of live monsters */

/*
 * TRUE if process_command() is a repeated call.
 */
bool command_repeating = FALSE;

/*
 * Dungeon variables
 */

byte feeling;			/* Most recent feeling */
s16b rating;			/* Level's current rating */

bool good_item_flag;	/* True if "Artifact" on this level */

bool closing_flag;		/* Dungeon is closing */

/*
 * Buffer to hold the current savefile name
 */
_TCHAR savefile[1024];
_TCHAR panic_savefile[1024];

/*
 * Number of active macros.
 */
s16b macro__num;

/*
 * Array of macro patterns [MACRO_MAX]
 */
_TCHAR **macro__pat;

/*
 * Array of macro actions [MACRO_MAX]
 */
_TCHAR **macro__act;

/*
 * The array[ANGBAND_TERM_MAX] of window pointers
 */
term *angband_term[ANGBAND_TERM_MAX];

/*
 * The array[ANGBAND_TERM_MAX] of window names (modifiable?)
 *
 * ToDo: Make the names independent of ANGBAND_TERM_MAX.
 */
_TCHAR angband_term_name[ANGBAND_TERM_MAX][16] =
{
	VERSION_NAME,
	__T("Term-1"),
	__T("Term-2"),
	__T("Term-3"),
	__T("Term-4"),
	__T("Term-5"),
	__T("Term-6"),
	__T("Term-7")
};

int max_macrotrigger = 0;
_TCHAR *macro_template = NULL;
_TCHAR *macro_modifier_chr;
_TCHAR *macro_modifier_name[MAX_MACRO_MOD];
_TCHAR *macro_trigger_name[MAX_MACRO_TRIGGER];
_TCHAR *macro_trigger_keycode[2][MAX_MACRO_TRIGGER];

/*
 * Global table of color definitions (mostly zeros)
 */
byte angband_color_table[MAX_COLORS][4] =
{
	{0x00, 0x00, 0x00, 0x00},	/* TERM_DARK */
	{0x00, 0xFF, 0xFF, 0xFF},	/* TERM_WHITE */
	{0x00, 0x80, 0x80, 0x80},	/* TERM_SLATE */
	{0x00, 0xFF, 0x80, 0x00},	/* TERM_ORANGE */
	{0x00, 0xC0, 0x00, 0x00},	/* TERM_RED */
	{0x00, 0x00, 0x80, 0x40},	/* TERM_GREEN */
	{0x00, 0x00, 0x40, 0xFF},	/* TERM_BLUE */
	{0x00, 0x80, 0x40, 0x00},	/* TERM_UMBER */
	{0x00, 0x60, 0x60, 0x60},	/* TERM_L_DARK */
	{0x00, 0xC0, 0xC0, 0xC0},	/* TERM_L_WHITE */
	{0x00, 0xFF, 0x00, 0xFF},	/* TERM_VIOLET */
	{0x00, 0xFF, 0xFF, 0x00},	/* TERM_YELLOW */
	{0x00, 0xFF, 0x40, 0x40},	/* TERM_L_RED */
	{0x00, 0x00, 0xFF, 0x00},	/* TERM_L_GREEN */
	{0x00, 0x00, 0xFF, 0xFF},	/* TERM_L_BLUE */
	{0x00, 0xC0, 0x80, 0x40}	/* TERM_L_UMBER */
};

/*
 * Standard sound (and message) names
 */
const _TCHAR *angband_sound_name[MSG_MAX] =
{
	__T(""),
	__T("hit"),
	__T("miss"),
	__T("flee"),
	__T("drop"),
	__T("kill"),
	__T("level"),
	__T("death"),
	__T("study"),
	__T("teleport"),
	__T("shoot"),
	__T("quaff"),
	__T("zap_rod"),
	__T("walk"),
	__T("tpother"),
	__T("hitwall"),
	__T("eat"),
	__T("store1"),
	__T("store2"),
	__T("store3"),
	__T("store4"),
	__T("dig"),
	__T("opendoor"),
	__T("shutdoor"),
	__T("tplevel"),
	__T("bell"),
	__T("nothing_to_open"),
	__T("lockpick_fail"),
	__T("stairs_down"),
	__T("hitpoint_warn"),
	__T("act_artifact"),
	__T("use_staff"),
	__T("destroy"),
	__T("mon_hit"),
	__T("mon_touch"),
	__T("mon_punch"),
	__T("mon_kick"),
	__T("mon_claw"),
	__T("mon_bite"),
	__T("mon_sting"),
	__T("mon_butt"),
	__T("mon_crush"),
	__T("mon_engulf"),
	__T("mon_crawl"),
	__T("mon_drool"),
	__T("mon_spit"),
	__T("mon_gaze"),
	__T("mon_wail"),
	__T("mon_spore"),
	__T("mon_beg"),
	__T("mon_insult"),
	__T("mon_moan"),
	__T("recover"),
	__T("blind"),
	__T("confused"),
	__T("poisoned"),
	__T("afraid"),
	__T("paralyzed"),
	__T("drugged"),
	__T("speed"),
	__T("slow"),
	__T("shield"),
	__T("blessed"),
	__T("hero"),
	__T("berserk"),
	__T("prot_evil"),
	__T("invuln"),
	__T("see_invis"),
	__T("infrared"),
	__T("res_acid"),
	__T("res_elec"),
	__T("res_fire"),
	__T("res_cold"),
	__T("res_pois"),
	__T("stun"),
	__T("cut"),
	__T("stairs_up"),
	__T("store_enter"),
	__T("store_leave"),
	__T("store_home"),
	__T("money1"),
	__T("money2"),
	__T("money3"),
	__T("shoot_hit"),
	__T("store5"),
	__T("lockpick"),
	__T("disarm"),
	__T("identify_bad"),
	__T("identify_ego"),
	__T("identify_art"),
	__T("breathe_elements"),
	__T("breathe_frost"),
	__T("breathe_elec"),
	__T("breathe_acid"),
	__T("breathe_gas"),
	__T("breathe_fire"),
	__T("breathe_confusion"),
	__T("breathe_disenchant"),
	__T("breathe_chaos"),
	__T("breathe_shards"),
	__T("breathe_sound"),
	__T("breathe_light"),
	__T("breathe_dark"),
	__T("breathe_nether"),
	__T("breathe_nexus"),
	__T("breathe_time"),
	__T("breathe_inertia"),
	__T("breathe_gravity"),
	__T("breathe_plasma"),
	__T("breathe_force"),
	__T("summon_monster"),
	__T("summon_angel"),
	__T("summon_undead"),
	__T("summon_animal"),
	__T("summon_spider"),
	__T("summon_hound"),
	__T("summon_hydra"),
	__T("summon_demon"),
	__T("summon_dragon"),
	__T("summon_gr_undead"),
	__T("summon_gr_dragon"),
	__T("summon_gr_demon"),
	__T("summon_ringwraith"),
	__T("summon_unique"),
	__T("wield"),
	__T("cursed"),
	__T("pseudo_id"),
	__T("hungry"),
	__T("notice"),
	__T("ambient_day"),
	__T("ambient_nite"),
	__T("ambient_dng1"),
	__T("ambient_dng2"),
	__T("ambient_dng3"),
	__T("ambient_dng4"),
	__T("ambient_dng5"),
	__T("mon_create_trap"),
	__T("mon_shriek"),
	__T("mon_cast_fear"),
	__T("hit_good"),
	__T("hit_great"),
	__T("hit_superb"),
	__T("hit_hi_great"),
	__T("hit_hi_superb"),
	__T("cast_spell"),
	__T("pray_prayer"),
	__T("kill_unique"),
	__T("kill_king"),
	__T("drain_stat"),
	__T("multiply")
};

/*
 * Array[VIEW_MAX] used by "update_view()"
 */
int view_n = 0;
u16b *view_g;

/*
 * Arrays[TEMP_MAX] used for various things
 *
 * Note that temp_g shares memory with temp_x and temp_y.
 */
int temp_n = 0;
u16b *temp_g;
byte *temp_y;
byte *temp_x;

/*
 * Array[DUNGEON_HGT][256] of cave grid info flags (padded)
 *
 * These arrays are padded to a width of 256 to allow fast access to elements
 * in the array via "grid" values (see the GRID() macros).
 */
byte (*cave_info)[256];
byte (*cave_info2)[256];

/*
 * Array[DUNGEON_HGT][DUNGEON_WID] of cave grid feature codes
 */
byte (*cave_feat)[DUNGEON_WID];

/*
 * Array[DUNGEON_HGT][DUNGEON_WID] of cave grid object indexes
 *
 * Note that this array yields the index of the top object in the stack of
 * objects in a given grid, using the "next_o_idx" field in that object to
 * indicate the next object in the stack, and so on, using zero to indicate
 * "nothing".  This array replicates the information contained in the object
 * list, for efficiency, providing extremely fast determination of whether
 * any object is in a grid, and relatively fast determination of which objects
 * are in a grid.
 */
s16b (*cave_o_idx)[DUNGEON_WID];

/*
 * Array[DUNGEON_HGT][DUNGEON_WID] of cave grid monster indexes
 *
 * Note that this array yields the index of the monster or player in a grid,
 * where negative numbers are used to represent the player, positive numbers
 * are used to represent a monster, and zero is used to indicate "nobody".
 * This array replicates the information contained in the monster list and
 * the player structure, but provides extremely fast determination of which,
 * if any, monster or player is in any given grid.
 */
s16b (*cave_m_idx)[DUNGEON_WID];

/*
 * Array[DUNGEON_HGT][DUNGEON_WID] of cave grid flow "cost" values
 */
byte (*cave_cost)[DUNGEON_WID];

/*
 * Array[DUNGEON_HGT][DUNGEON_WID] of cave grid flow "when" stamps
 */
byte (*cave_when)[DUNGEON_WID];

/*
 * Array[z_info->o_max] of dungeon objects
 */
object_type *o_list;

/*
 * Array[z_info->m_max] of dungeon monsters
 */
monster_type *mon_list;

/*
 * Total monster power
 */
s32b tot_mon_power;

/*
 * Array[z_info->r_max] of monster lore
 */
monster_lore *l_list;

/*
 * Hack -- Array[MAX_Q_IDX] of quests
 */
quest *q_list;

/*
 * Array[MAX_STORES] of stores
 */
store_type *store;

/*
 * Array[INVEN_TOTAL] of objects in the player's inventory
 */
object_type *inventory;

/*
 * The size of the "alloc_ego_table"
 */
s16b alloc_ego_size;

/*
 * The array[alloc_ego_size] of entries in the "ego allocator table"
 */
alloc_entry *alloc_ego_table;

/*
 * The size of "alloc_race_table" (at most z_info->r_max)
 */
s16b alloc_race_size;

/*
 * The array[alloc_race_size] of entries in the "race allocator table"
 */
alloc_entry *alloc_race_table;

/*
 * Specify attr/char pairs for visual special effects
 * Be sure to use "index & 0xFF" to avoid illegal access
 */
byte misc_to_attr[256];
char misc_to_char[256];

/*
 * Specify color for inventory item text display (by tval)
 * Be sure to use "index & 0x7F" to avoid illegal access
 */
byte tval_to_attr[128];

/*
 * Current (or recent) macro action
 */
_TCHAR macro_buffer[1024];

/*
 * Keymaps for each "mode" associated with each keypress.
 */
_TCHAR *keymap_act[KEYMAP_MODES][257];

/*** Player information ***/

/*
 * Pointer to the player tables (sex, race, class, magic)
 */
const player_sex *sp_ptr;
const player_race *rp_ptr;
const player_class *cp_ptr;
const player_magic *mp_ptr;

/*
 * The player other record (static)
 */
static player_other player_other_body;

/*
 * Pointer to the player other record
 */
player_other *op_ptr = &player_other_body;

/*
 * The player info record (static)
 */
static player_type player_type_body;

/*
 * Pointer to the player info record
 */
player_type *p_ptr = &player_type_body;

/*
 * Structure (not array) of size limits
 */
maxima *z_info;

/*
 * The vault generation arrays
 */
vault_type *v_info;
_TCHAR *v_name;
_TCHAR *v_text;

/*
 * The terrain feature arrays
 */
feature_type *f_info;
_TCHAR *f_name;
_TCHAR *f_text;

/*
 * The object kind arrays
 */
object_kind *k_info;
_TCHAR *k_name;
_TCHAR *k_text;

/*
 * The artifact arrays
 */
artifact_type *a_info;
_TCHAR *a_name;
_TCHAR *a_text;

/*
 * The ego-item arrays
 */
ego_item_type *e_info;
_TCHAR *e_name;
_TCHAR *e_text;
flag_cache *slay_cache;

/*
 * The monster race arrays
 */
monster_race *r_info;
_TCHAR *r_name;
_TCHAR *r_text;

/*
 * The player race arrays
 */
player_race *p_info;
_TCHAR *p_name;
_TCHAR *p_text;

/*
 * The player class arrays
 */
player_class *c_info;
_TCHAR *c_name;
_TCHAR *c_text;

/*
 * The player history arrays
 */
hist_type *h_info;
_TCHAR *h_text;

/*
 * The shop owner arrays
 */
owner_type *b_info;
_TCHAR *b_name;
_TCHAR *b_text;

/*
 * The object flavor arrays
 */
flavor_type *flavor_info;
_TCHAR *flavor_name;
_TCHAR *flavor_text;

/*
 * The spell arrays
 */
spell_type *s_info;
_TCHAR *s_name;
_TCHAR *s_text;

/*
 * The spell_list is built from s_info to facilitate a quick lookup
 * of the spell when realm, book and position in book are known.
 */
s16b spell_list[MAX_REALMS][BOOKS_PER_REALM][SPELLS_PER_BOOK];

/*
 * Hack -- The special Angband "System Suffix"
 * This variable is used to choose an appropriate "pref-xxx" file
 */
const _TCHAR *ANGBAND_SYS = __T("xxx");

/*
 * Hack -- The special Angband "Graphics Suffix"
 * This variable is used to choose an appropriate "graf-xxx" file
 */
const _TCHAR *ANGBAND_GRAF = __T("old");

/*
 * Path name: The main "lib" directory
 * This variable is not actually used anywhere in the code
 */
_TCHAR *ANGBAND_DIR;

/*
 * Various lib/ sub-directories.
 */
_TCHAR *ANGBAND_DIR_APEX;
_TCHAR *ANGBAND_DIR_BONE;
_TCHAR *ANGBAND_DIR_DATA;
_TCHAR *ANGBAND_DIR_EDIT;
_TCHAR *ANGBAND_DIR_FILE;
_TCHAR *ANGBAND_DIR_HELP;
_TCHAR *ANGBAND_DIR_INFO;
_TCHAR *ANGBAND_DIR_SAVE;
_TCHAR *ANGBAND_DIR_PREF;
_TCHAR *ANGBAND_DIR_USER;
_TCHAR *ANGBAND_DIR_XTRA;

/*
 * Various xtra/ subdirectories.
 */
_TCHAR *ANGBAND_DIR_XTRA_FONT;
_TCHAR *ANGBAND_DIR_XTRA_GRAF;
_TCHAR *ANGBAND_DIR_XTRA_SOUND;
_TCHAR *ANGBAND_DIR_XTRA_HELP;
_TCHAR *ANGBAND_DIR_XTRA_ICON;

/*
 * Total Hack -- allow all items to be listed (even empty ones)
 * This is only used by "do_cmd_inven_e()" and is cleared there.
 */
bool item_tester_full;

/*
 * Here is a "pseudo-hook" used during calls to "get_item()" and
 * "show_inven()" and "show_equip()", and the choice window routines.
 */
byte item_tester_tval;

/*
 * Here is a "hook" used during calls to "get_item()" and
 * "show_inven()" and "show_equip()", and the choice window routines.
 */
bool (*item_tester_hook)(const object_type*);

/*
 * Hack -- function hook to restrict "get_mon_num_prep()" function
 */
bool (*get_mon_num_hook)(int r_idx);

/*
 * Hack -- function hook to restrict "get_obj_num_prep()" function
 */
bool (*get_obj_num_hook)(int k_idx);

/*
 * Hack - the destination file for text_out_to_file.
 */
ang_file *text_out_file = NULL;

/*
 * Hack -- function hook to output (colored) text to the
 * screen or to a file.
 */
void (*text_out_hook)(byte a, const _TCHAR *str);

/*
 * Hack -- Where to wrap the text when using text_out().  Use the default
 * value (for example the screen width) when 'text_out_wrap' is 0.
 */
int text_out_wrap = 0;

/*
 * Hack -- Indentation for the text when using text_out().
 */
int text_out_indent = 0;

/*
 * Use transparent tiles
 */
bool use_transparency = FALSE;

/*
 * Sound hook (for playing FX).
 */
void (*sound_hook)(int sound);

/*
 * For autoinscriptions.
 */
autoinscription *inscriptions = 0;
u16b inscriptions_count = 0;

/* Delay in centiseconds before moving to allow another keypress */
/* Zero means normal instant movement. */
u16b lazymove_delay = 0;
