/**
 *@author touyou_hk
 *@author General BlackBunny
 */

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;

import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.co.touyouhk.util.UniversalUtil;


/**
 * 
 * 要求のあったURLのファイルを取得し、要求元へ返却します
 */
public class GetWebContentsServlet extends HttpServlet{

	/**
	 * ex:http://localhost:8080/2chMtMt4Jsp/GetWebContentsServlet?url=http://www.yahoo.co.jp/
	 * ex:http://localhost:8080/2chMtMt4Jsp/GetWebContentsServlet?url=http://kilauea.bbspink.com/test/read.cgi/hgame2/1333342832/
	 */
	public void doGet(HttpServletRequest request, HttpServletResponse response) {

		String paramUrl = request.getParameter("url");

		// 取得コンテンツのエンコードを指定します
		String encode = request.getParameter("encode");
		
		// TODO 修正必要
		// 2chのデフォがShiftJISなのでとりあえずデフォは設定
		if(UniversalUtil.isBlank(encode)) {
			encode = "Windows-31J";
		}
		
		if (!UniversalUtil.isBlank(paramUrl)) {
			try {
				response.setContentType("text/html; charset=" + encode);
				
				OutputStream out = response.getOutputStream();
				
				byte buf[] = new byte[4069];
				int num;
				InputStream di = download(paramUrl);
				while ((num = di.read(buf)) != -1) {

					out.write(buf, 0, num);

				}
				
			} catch (IOException e) {
				// TODO 自動生成された catch ブロック
				e.printStackTrace();
			}
		}
	}
	
	
	
	/**
	 * 指定されたURLのファイルをダウンロードしInputStream型で返却します<br>
	 * @param URL
	 * @return ダウンロードしたオブジェクト(InputStream)
	 * @throws IOException 
	 */
	private static InputStream download(String inputUrl) throws IOException {
		URL url =new URL(inputUrl);
		Object obj;
		obj = url.getContent();
		return (InputStream) obj;
	}

}

