/*
 * jquery.zweiChThredView.js
 * 2ch-HTMLをスレッドビューワーとして見やすく加工するメソッド群
 * 
 * Jsライブラリのため2ch(HTML版)をターゲットとしています
 * 2ch(DAT版)はターゲットとしてないのでDATをHTMLに変換して当ライブラリを使用してください。
 * 当ライブラリは「2chMatometter」という2chまとめ作成ソフトから
 * 汎用的に使用できるメソッドを切り出したものになります。
 * https://sourceforge.jp/projects/j2chmatometter/
 * 
 * Ver 0.1
 * @author General BlackBunny (ジェネラル・黒うさぎ twitter:@GeneralBBunny)
 * 
 * Dual licensed under the MIT or GPL Version 2 licenses.
 * Copyright ©2012 GeneralBlackBunny. All Rights Reserved
 */

// スレッドビューワーからコピーフレームにコピーさせたくないもの
// コピーする時に削除
var NOTCOPY_MARK = "notCopy2Frame";
// コピーする時に元に戻す
var REORIGN_MARK = "reOrigin";

/**
 * 2ch-HTMLのレスにデータ処理用の番号をjQueryのdataメソッドで紐付けします
 * 		レスの番号でなくHTMLのddの順番を設定します。
 * @selecter 2ch-HTML
 */
jQuery.fn.setResDataNum = function() {
	// レスの順番
	var num = 1;
	var $targets = jQuery(this).find("dd");
	$targets.each(function() {
		$(this).data("resDNum",num);
		num++;
	});
	
	return this;
};


/**
 * 2ch-HTMLのレス数に応じたIDの強調表示をします。
 * またレス数のMAX値と現在値を表示します。
 * 
 * [オプション]
 * jQuery.fn.idCounterView.strongNum = "強調表示するレス数を設定 N以上" (デフォルト <=5)
 * jQuery.fn.idCounterView.dspNowMax = レス数の現在値/レス数のMAX値をHTMLに表示するかの可否 デフォルトfalse)
 * jQuery.fn.idCounterView.color = ID強調表示用のカラー (デフォルトred)
 * 
 * @selecter 2ch-HTML
 */
jQuery.fn.idCounterView = function() {

	//オプション初期処理
	if(!jQuery.fn.idCounterView.strongNum) {
		// IDの強調表示をするレス値
		jQuery.fn.idCounterView.strongNum = 5;
	}
	if(!jQuery.fn.idCounterView.dspNowMax) {
		// レスのNOW/MAXの表示可否
		jQuery.fn.idCounterView.dspNowMax = false;
	}
	if(!jQuery.fn.idCounterView.color) {
		jQuery.fn.idCounterView.color = "red";
	}
	
	// オプションをローカル変数に保持
	var strongNum = jQuery.fn.idCounterView.strongNum;
	var dspNowMax = jQuery.fn.idCounterView.dspNowMax;
	var color = jQuery.fn.idCounterView.color;
	
	// IDのMapを作成 (id値:レス数)
	var idMap = {};
	var id;

	var $targets = jQuery(this).find("dt");
	$targets.each(function() {
		
		id = findResId($(this).html());

		// idがない、もしくは???の場合はMAPをつくらない
		if(id !== null){
			// レスカウンターを加算
			if(!idMap[id]) {
				idMap[id] = 0;
			}
			idMap[id]++;
		}
		// DOM要素に現在のレス数(NOW)を保存(糞処理が重い)
		//$targets.data("now", idMap[id]);
	});
	
	// ■算出したMAP値を元にHTMLを装飾します
	var orign,result;

	// NOW値用のMAP
	var idMap4Now = {};
	$targets.each(function() {
		id = findResId($(this).html());
		
		if(id === null){
			return;
		}
		// NOW/MAX値表示オプションがtrueの時はNOW/MAP値を表示 (強調表示よりも先にする)
		if(dspNowMax) {
			// レスカウンターを加算
			if(!idMap4Now[id]) {
				idMap4Now[id] = 0;
			}
			idMap4Now[id]++;
			
			result = replaceResId(
					$(this).html(),
					"$1 <font class=\"" + NOTCOPY_MARK + "\">" + idMap4Now[id] + "/" + idMap[id] + "</font>");
			// 編集した結果を格納
			$(this).html(result);
		}
		
		// レス数が強調表示値を超えていたら指定色で装飾
		if(strongNum <= idMap[id]) {
			result = replaceResId($(this).html(),"<font color=\"red\" class=\"" + REORIGN_MARK + "\" >$1</font>");
			// 編集した結果を格納
			$(this).html(result);
		}
	});
	
	return this;
};

// 527 ：名無しさん＠ピンキー：2012/05/12(土) 20:56:50.32 ID:nq12gp1h0 3/4
// 527 ：名無しさん＠ピンキー：2012/05/12(土) 20:56:50.32 ID:nq12gp1h0 3/4 (>>:10) ・・・>>自体が処理にひっかかる可能性が出てくるので却下
// 527 ：名無しさん＠ピンキー：2012/05/12(土) 20:56:50.32 ID:nq12gp1h0 3/4 (AN:10)
/**
 * アンカー強調表示を実行します
 * 指定されたしきい値以上にアンカーレスされたレス番号を強調表示(Bold+指定色)します
 * またDTタグの末尾にアンカーされた数を表示します(色:緑)
 * 
 * [オプション]
 * jQuery.fn.resAnchorView.num=しきい値(デフォルト3)
 * jQuery.fn.resAnchorView.color=強調表示の色(デフォルトred)
 * jQuery.fn.resAnchorView.numDsp =アンカーされた数の表示可否(デフォルトfalse)
 * jQuery.fn.resAnchorView.numDspColor = アンカー数の表示色(デフォルト:green)
 * 
 * @selecter 2ch-HTML
 *　@return this-jQueryObject
 */
jQuery.fn.resAnchorView = function() {
	// レスの順番
	var num = 1;
	var $targets = jQuery(this).find("dd");
	$targets.each(function() {
		$(this).data("resDNum",num);
		num++;
	});
	
	return this;
};

/**
 * このプラグインで付与したHTMLを元に戻します
 * 引数にはコピー先のフレームのjQueryオブジェクトを渡してください
 * オリジナルのスレッドフレームのjQueyオブジェクトを渡すとオリジナルのHTMLが破壊されます
 * 
 * @selecter 2ch-HTML (コピーフレーム)
 * @return jQuryオブジェクト
 */
jQuery.fn.threadViewDelete = function() {

	jQuery(this).find("." + NOTCOPY_MARK).remove();
	
	jQuery(this).find("." + REORIGN_MARK).replaceWith(jQuery(this).find("." + REORIGN_MARK).text());
	
	return this;
};


/**
 * 2chのレスIDを探します
 * @param string (文字列、2ch-HTML　dt要素の文字列)
 * @returns 検索できたid。検索不一致ならnull
 */
function findResId(string) {
	var regex = /ID:.{9}/;
	var regex8 = /ID:.{8}/;
	var id;
	
	//テキスト内から正規表現で検索
	id = string.match(regex);

	//idが9桁でマッチしない場合はIDは8桁と判断し再度検索にかける
	if(id === null){
		id = string.match(regex8);
	}
	
	return id;
}


/**
 * 2chのレスIDを元に正規表現でreplaceします
 * @param string (文字列、2ch-HTML　dt要素の文字列)
 * @param change (置き換え後の文字列)
 * @returns 置き換えた文字列。検索にマッチせず置き換えられなかったら引数のstring
 */
function replaceResId(string,change) {
	var regex4replace = /(ID:.{9})/;
	var regex4replace8 = /(ID:.{8})/;
	var result;
	
	//テキスト内から正規表現で検索
	result = string.replace(regex4replace,change);
	
	//idが9桁でマッチしない場合はIDは8桁と判断し再度検索にかける
	if(result === string){
		result = string.replace(regex4replace8,change);
	}
	
	return result;
}