/**
 * 詳細編集画面用のJS
 * cleditorを使用
 */

// http://premiumsoftware.net/cleditor/docs/GettingStarted.html
$(document).ready(function(){ 
	
	otherInit();
	
	$("#input").cleditor({
	          width:        1000, // width not including margins, borders or padding          
	          height:       600 // height not including margins, borders or padding		
	});
	
	

	});

function otherInit(){
//var fontFix = '<div style="font-size:16px;line-height:18px;">';
//http://tail.s170.xrea.com/html/text/aa_promo/aa_setting/
var fontFix = '<div style="font-family:\'ＭＳ Ｐゴシック\',\'ＭＳＰゴシック\',\'MSPゴシック\',\'MS Pゴシック\';font-size:16px;line-height:18px;" > ';
	var htmlData = $("#edit").html();
	
	if (htmlData != null) {
		
		// 履歴一覧から読み込んだ時はDIVを再度つけないにようにする
		var headchar = htmlData.slice(1,4);
		
		//alert(headchar);
		
		if("div" !== headchar) {
			htmlData = fontFix + htmlData;
		}
		
		$("#input").val(htmlData);
	}
	 var orignName = $("#hstSaveFileName").text();
	$("#saveFileName").val(  orignName.slice(0,-5));
	
	
	$(".jui_button").button();
	
	
	// 保存ボタンのイベント登録
	$("#saveButton").click(function() {
		saveHtml();
	});
	
	// ファイル名入力エリアでEnterを押された時の動作
	$("#saveFileName").keypress(function(event) {
		if(13 === event.which){
			return false;
		}
	});
	$("#saveFileName").keydown(function(event) {
		if(13 === event.which){
			return false;
		}
	});
	
	
	// プラグイン用チェックボックスのイベント登録
	pluginCheckBoxAllOnload();
	

	//　プラグイン実行ボタンへのイベント登録
	$("#blogPluginExecuteButton").click(
			function() {
				// HTMLオブジェクトの取得
				var $htmlObj = $("iframe").contents().find("body");
				//alert($htmlObj.html());
				pluginExecuter($htmlObj);
			}
	);
	
	// 改行差し込みボタンへのイベント登録
	$("#insertReturnCode").click(function() {
		// HTMLオブジェクトの取得
		var $htmlObj = $("iframe").contents().find("body");
		$htmlObj.insertReturnCode();
		// ソースエリアにも反映
		$("#input").cleditor()[0].updateTextArea();
	});
	// 改行削除ボタンへのイベント登録
	$("#deleteReturnCode").click(function() {
		// HTMLオブジェクトの取得
		var $htmlObj = $("iframe").contents().find("body");
		$htmlObj.deleteReturnCode();
		// ソースエリアにも反映
		$("#input").cleditor()[0].updateTextArea();
	});
	
}


/**
 * HTML保存機能
 */
function saveHtml() {
	if( $("#saveFileName").val() === "") {
		//common_msg("", "保存ファイル名が指定されていません");
		common_alert("","保存ファイル名が指定されていません");
		return;
	}
	saveHtmlAPLogicCall();
}

/**
 * ファイル保存のためのAPを呼び出す
 * HTML5で代替可能(IE以外)
 */
function saveHtmlAPLogicCall(){
	// POSTする内容を取得・整形
	
	//cleditorの内容をHTMLソース化して#htmlTextAreaにコピー
	var postData = $("iframe").contents().find("body").html();
	
	//alert(postData);
	//return;
	
	$("#htmlTextArea").html(postData);

	// POSTしてサーブレットの呼びだし
	$("#saveHtmlSubmit").click();
}



/* TODO 処理中がわかるダイアログかローディング画面が必要
 * 各プラグインの処理中がわかるメッセージが必要
*/
/**
 * プラグインを実行します
 * @param $htmlObj jQuery HTMLオブジェクト
 */
function pluginExecuter($htmlObj){
	
	// 注意！プラグインの実行順序に注意
	
	// dtタグでfindするのでreplaceDtDd2DivPの前に実行
 	if($("#idLinkCanceler").judgeCheckBox()){
 		$htmlObj.idLinkCanceler();
 	}
 	
 	// dd-fontでfindするのでreplaceDtDd2DivPの前に実行
 	if($("#keyWordLinkCanceler").judgeCheckBox()){
 		$htmlObj.keyWordLinkCanceler();
 	}
 	
 	if($("#replaceDtDd2DivP").judgeCheckBox()){
 		$htmlObj.replaceDtDd2DivP();
 	}
 	

 	// ソースエリアにも変更を反映させる
	// 参考URL
	//http://premiumsoftware.net/cleditor/docs/GettingStarted.html#
	//http://premiumsoftware.net/cleditor/docs/GettingStarted.html#cleditorMethod
	$("#input").cleditor()[0].updateTextArea();
	//$("#input").cleditor()[0].updateFrame();
}

/*参考 [cleditorのソースボタン部ソース]
//Toggle source
if (buttonName == "source") {

// Show the iframe
if (sourceMode(editor)) {
 delete editor.range;
 editor.$area.hide();
 editor.$frame.show();
 buttonDiv.title = button.title;
}

// Show the textarea
else {
 editor.$frame.hide();
 editor.$area.show();
 buttonDiv.title = "Show Rich Text";
}

// Enable or disable the toolbar buttons
// IE requires the timeout
setTimeout(function() {refreshButtons(editor);}, 100);

}
*/
