

import java.io.File;
import java.io.IOException;
import java.util.List;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import jp.co.touyouhk.util.file.TextUtil;



import dragunova.DragunovaConstants;
import dragunova.ServletUtil;



/**
 * Servlet implementation class SaveEditedHtmlServlet
 */
@WebServlet(description = "編集後のHTMLを保存するためのサーブレット", urlPatterns = { "/SaveEditedHtmlServlet" })
public class SaveEditedHtmlServlet extends HttpServlet {
	private static final long serialVersionUID = 1L;
	
	/**
	 * 保存ディレクトリのパス
	 */
	
	private static String saveEndFilePath = "";
	
	enum FileCreateResult {
		FAIL, // ファイル作成失敗
		SUCCESS_NEW, // ファイル新規作成
		SUCCESS_OVER_UPDATA, //上書き保存
		SUCCESS_UPDATA // ファイル更新
	}

       
    /**
     * @see HttpServlet#HttpServlet()
     */
    public SaveEditedHtmlServlet() {
        super();
        // TODO Auto-generated constructor stub
    }

	/**
	 * @see HttpServlet#doGet(HttpServletRequest request, HttpServletResponse response)
	 */
	protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		// TODO Auto-generated method stub
	}

	/**
	 * @see HttpServlet#doPost(HttpServletRequest request, HttpServletResponse response)
	 */
	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		
		request.setCharacterEncoding("Windows-31J");
		
		
		String saveFileName = request.getParameter("saveFileName");
		String htmlText = request.getParameter("htmlTextArea");
		
		String resultMsg = "";
		FileCreateResult result = null;
		
		// Tomcatのデフォは 保存先=C:\Dev\apache-tomcat\bin
		// Eclipse経由でのAP起動の場合は C:\plea36\eclipse
		String currentDirectory = (new File(".")).getAbsoluteFile().getParentFile().toString();
		


		try {
		 result = htmlFileSave(saveFileName, htmlText);
			String saveDirectoryMsg = " 保存先=" + saveEndFilePath;
			
			switch (result) {
			case SUCCESS_NEW:
				resultMsg = "ファイルを保存しました。(新規作成) " + saveDirectoryMsg;
				break;
			case SUCCESS_OVER_UPDATA:
				resultMsg = "ファイルを保存しました。(ファイル上書き保存) " + saveDirectoryMsg;
				break;
			default:
				break;
			}
		}
		catch (IOException e) {
			resultMsg = "ファイルの保存に失敗しました。 " + e.toString() + "保存しようとしたパス=" + DragunovaConstants.HTML_SAVE_DIRECTORY + "  カレントディレクトリ=" + 
			currentDirectory;
		}
		

		// 保存したファイル一覧を取得します
		List<String> fileList = ServletUtil.getSaveFileList();
		
		
		request.setAttribute("resultMsg", resultMsg);
		request.setAttribute("htmlText", htmlText);
		request.setAttribute("fileList", fileList);
		
		RequestDispatcher dispatcher = request.getRequestDispatcher("hstlist.jsp");
		
		response.setContentType("text/html; charset=Windows-31J");
		dispatcher.forward(request, response);		
	}

	
	/**
	 * 指定されたファイル名でHTMLを保存します。ファイル名の末尾に.htmlを付与します
	 * @param fileName
	 * @param data
	 * @throws IOException 
	 */
	private static FileCreateResult htmlFileSave (String fileName, String data) throws IOException {
		
		fileName += ".html";

		return fileSave(DragunovaConstants.HTML_SAVE_DIRECTORY, fileName, data);
	}
	
	
	/**
	 * Stringの内容を指定されたファイルにセーブします
	 * @param saveDirectory
	 * @param fileName
	 * @param data
	 * @throws IOException 
	 */
	private static FileCreateResult fileSave (String saveDirectory, String fileName, String data) throws IOException {
		
		String fileSavePath = saveDirectory + fileName;
		
		File file = new File(fileSavePath);
		
		// フォルダがなかったら作成する
		
		// ファイルを作成する、もし存在するならfalse
		boolean fileExist = file.createNewFile();
		
		saveEndFilePath = file.getAbsolutePath();
		
		FileCreateResult result = null;
		
		if (fileExist == true) {
			result = FileCreateResult.SUCCESS_NEW;
		} else {
			result  = FileCreateResult.SUCCESS_OVER_UPDATA;
		}
		
		TextUtil.string2File(data, fileSavePath, "Shift_JIS", false);
		
		return result;
	}
}
