//
//  CRDropView.m
//  ImageSpliter
//
//  Created by hiroshi tomioka on 13/02/12.
//  Copyright (c) 2013年 hiroshi tomioka. All rights reserved.
//
//  画像ドロップの為のメインウィンドウ

#import "CRDropView.h"
#import <Foundation/Foundation.h>

@implementation CRDropView

@synthesize _files;

- (id)initWithFrame:(NSRect)frame
{
    self = [super initWithFrame:frame];
    if (self) {
        // Initialization code here.
		self._files = [NSMutableArray arrayWithCapacity:1];
    }
    
    return self;
}

- (void)awakeFromNib {
	self._files = [NSMutableArray arrayWithCapacity:1];
	[self registerForDraggedTypes:[NSArray arrayWithObjects:
									   NSColorPboardType, NSFilenamesPboardType, nil]];

}

- (void)drawRect:(NSRect)dirtyRect
{
    // Drawing code here.
}

//画像ファイルのチェック
- (BOOL)isImageFile:(NSString*)filePath
{
	BOOL    isImageFile = NO;
	LSItemInfoRecord        info;
	CFStringRef uti = NULL;
	@try {

	CFURLRef url = CFURLCreateWithFileSystemPath(NULL,
												 (CFStringRef)filePath, kCFURLPOSIXPathStyle, FALSE);
	
	if (LSCopyItemInfoForURL(url, kLSRequestExtension |
							 kLSRequestTypeCreator, &info) == noErr)
	{
		if (info.extension != NULL)
		{
			uti =
			UTTypeCreatePreferredIdentifierForTag(kUTTagClassFilenameExtension,
												  info.extension, kUTTypeData);
			CFRelease(info.extension);
		}
		
		if (uti == NULL)
		{
			CFStringRef typeString =
			UTCreateStringForOSType(info.filetype);
			if ( typeString != NULL)
			{
				uti =
				UTTypeCreatePreferredIdentifierForTag(kUTTagClassOSType,
													  typeString, kUTTypeData);
				CFRelease(typeString);
			}
		}
		
		if (uti != NULL)
		{
			CFArrayRef supportedTypes =
			CGImageSourceCopyTypeIdentifiers();
			CFIndex i, typeCount = CFArrayGetCount(supportedTypes);
			
			for (i = 0; i < typeCount; i++)
			{
				if (UTTypeConformsTo(uti,
									 (CFStringRef)CFArrayGetValueAtIndex(supportedTypes, i)))
				{
					isImageFile = YES;
					break;
				}
			}
		}
	}

	}
	@catch (NSException *exception) {

	}
	@finally {
	}

	return isImageFile;
}

- (NSDragOperation)draggingEntered:(id <NSDraggingInfo>)sender
{
    if ((NSDragOperationGeneric & [sender draggingSourceOperationMask])
		== NSDragOperationGeneric)
    {
        //this means that the sender is offering the type of operation we want
        //return that we want the NSDragOperationGeneric operation that they
		//are offering
        return NSDragOperationGeneric;
    }
    else
    {
        //since they aren't offering the type of operation we want, we have
		//to tell them we aren't interested
        return NSDragOperationNone;
    }
}

- (void)draggingExited:(id <NSDraggingInfo>)sender
{
    //we aren't particularily interested in this so we will do nothing
    //this is one of the methods that we do not have to implement
}

- (NSDragOperation)draggingUpdated:(id <NSDraggingInfo>)sender
{
    if ((NSDragOperationGeneric & [sender draggingSourceOperationMask])
		== NSDragOperationGeneric)
    {
        //this means that the sender is offering the type of operation we want
        //return that we want the NSDragOperationGeneric operation that they
		//are offering
        return NSDragOperationGeneric;
    }
    else
    {
        //since they aren't offering the type of operation we want, we have
		//to tell them we aren't interested
        return NSDragOperationNone;
    }
}


- (BOOL)performDragOperation:(id <NSDraggingInfo>)sender
{
    NSPasteboard *paste = [sender draggingPasteboard];
	//gets the dragging-specific pasteboard from the sender
    NSArray *types = [NSArray arrayWithObjects:NSTIFFPboardType,
					  NSFilenamesPboardType, nil];
	//a list of types that we can accept
    NSString *desiredType = [paste availableTypeFromArray:types];
    NSData *carriedData = [paste dataForType:desiredType];
	
    if (nil == carriedData)
    {
        //the operation failed for some reason
        NSRunAlertPanel(@"Error", @"",
						nil, nil, nil);
        return NO;
    }
    else
    {
        if ([desiredType isEqualToString:NSFilenamesPboardType])
        {
            NSArray *fileArray =
			[paste propertyListForType:@"NSFilenamesPboardType"];
			//サブフォルダを含め、画像ファイルをNSArrayに追加
			for (NSString *path in fileArray) {
				BOOL isDirectory;
				if ([[NSFileManager defaultManager] fileExistsAtPath:path isDirectory:&isDirectory]) {
					if (isDirectory) {
						NSArray* array = [[NSFileManager defaultManager] subpathsAtPath:path];
						array = [array sortedArrayUsingSelector:@selector(caseInsensitiveCompare:)];
	
						for (NSString *filename in array) {
							filename = [path stringByAppendingPathComponent:filename];
							if ([self isImageFile:filename]) {
								NSLog(@"%@", filename);
								[self._files addObject:filename];
							}
						}
					} else {
						if ([self isImageFile:path]) {
							[self._files addObject:path];
						}
					}
	
				}
				
			}
			
			//ファイルがドロップされた事への通知、これでTableViewが更新される
			NSDictionary* dic = [NSDictionary dictionaryWithObjectsAndKeys:self._files, @"files", nil];
			NSNotification* notification = [NSNotification notificationWithName:@"files droped"
																		 object:self
																	   userInfo:dic];
			[[NSNotificationCenter defaultCenter] postNotification:notification];
			
        }
        else
        {
            //this can't happen
            NSAssert(NO, @"This can't happen");
            return NO;
        }
    }
    return YES;
}

@end
